% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xVACalculator.R
\name{xVACalculator}
\alias{xVACalculator}
\title{Calculates the xVA values}
\usage{
xVACalculator(trades, col, sim_data, reg_data, credit_curve_PO,
  credit_curve_cpty, funding_curve, spot_rates, cpty_LGD, PO_LGD)
}
\arguments{
\item{trades}{The full list of the Trade Objects}

\item{col}{The margin agreement with the counterparty}

\item{sim_data}{A list containing data related to the calculation of simulated exposures (for example the model parameters and the number of simulations)}

\item{reg_data}{A list containing data related to the regulatory calculations (for example the 'framework' member variable can be 'IMM','SACCR','CEM')}

\item{credit_curve_PO}{The credit curve of the processing organisation}

\item{credit_curve_cpty}{The credit curve of the processing organisation}

\item{funding_curve}{A curve containing the credit spread for the funding of the collateral}

\item{spot_rates}{The spot rates curve}

\item{cpty_LGD}{The loss-given-default of the counterparty}

\item{PO_LGD}{The loss-given-default of the processing organisation}
}
\value{
A list containing the xVA values
}
\description{
Calculates the xVA values (CVA, DVA, FVA, FBA, MVA, KVA)
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
\references{
Gregory J., The xVA Challenge, 2015, Wiley
}

