% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2.R
\name{theme_xaringan_inverse}
\alias{theme_xaringan_inverse}
\title{An Inverse Plot Theme for ggplot2 by xaringanthemer}
\usage{
theme_xaringan_inverse(
  text_color = NULL,
  background_color = NULL,
  accent_color = NULL,
  accent_secondary_color = NULL,
  css_file = NULL,
  set_ggplot_defaults = TRUE,
  text_font = NULL,
  text_font_use_google = NULL,
  text_font_size = NULL,
  title_font = NULL,
  title_font_use_google = NULL,
  title_font_size = NULL,
  use_showtext = TRUE
)
}
\arguments{
\item{text_color}{Color for text and foreground, inherits from \code{text_color}}

\item{background_color}{Color for background, inherits from
\code{background_color}}

\item{accent_color}{Color for titles and accents, inherits from
\code{header_color}}

\item{accent_secondary_color}{Color for secondary accents, inherits from
\code{text_bold_color}}

\item{css_file}{Path to a \pkg{xaringanthemer} CSS file, from which the
theme variables and values will be inferred. In general, if you use the
\pkg{xaringathemer} defaults, you will not need to set this. This feature
lets you create a \pkg{ggplot2} theme for your \pkg{xaringan} slides, even
if you have only saved your theme CSS file and you aren't creating your
CSS theme with \pkg{xaringanthemer} in your slides' source file.}

\item{set_ggplot_defaults}{Should defaults be set for \pkg{ggplot2} \emph{geoms}?
Defaults to TRUE. To restore ggplot's defaults, or the previously set geom
defaults, see \code{\link[=theme_xaringan_restore_defaults]{theme_xaringan_restore_defaults()}}.}

\item{text_font}{Font to use for text elements, passed to
\code{\link[sysfonts:font_add_google]{sysfonts::font_add_google()}}, if available and \code{text_font_use_google} is
\code{TRUE}. Inherits from \code{text_font_family}. If manually specified, can be a
\code{\link[=google_font]{google_font()}}.}

\item{text_font_use_google}{Is \code{text_font} available on \href{https://fonts.google.com}{Google Fonts}?}

\item{text_font_size}{Base text font size, inherits from \code{text_font_size}, or
defaults to 11.}

\item{title_font}{Font to use for title elements, passed to
\code{\link[sysfonts:font_add_google]{sysfonts::font_add_google()}}, if available and \code{title_font_use_google} is
\code{TRUE}. Inherits from \code{title_font_family}. If manually specified, can be a
\code{\link[=google_font]{google_font()}}.}

\item{title_font_use_google}{Is \code{title_font} available on \href{https://fonts.google.com}{Google Fonts}?}

\item{title_font_size}{Base text font size, inherits from \code{title_font_size},
or defaults to 14.}

\item{use_showtext}{If \code{TRUE} (default) the \pkg{showtext} package will be
used to register Google fonts. Set to \code{FALSE} to disable this feature
entirely, which may result in errors during plotting if the fonts used are
not available locally.}
}
\value{
A ggplot2 theme
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

A \pkg{ggplot2} xaringanthemer plot theme to seamlessly match the "inverse"
\pkg{xaringan} slide colors and styles as styled by \link{xaringanthemer}. See
\code{vignette("ggplot2-themes")} for more information and examples.
}
\examples{
# Requires ggplot2
has_ggplot2 <- requireNamespace("ggplot2", quietly = TRUE)

if (has_ggplot2) {
  # Because this is an example, we'll save the CSS to a temp file
  path_to_css_file <- tempfile(fileext = ".css")

  # Create the xaringan theme: dark blue background with teal green accents
  style_duo(
    primary_color = "#002b36",
    secondary_color = "#31b09e",
    # Using basic fonts for this example, but the plot theme will
    # automatically use your theme font if you use Google fonts
    text_font_family = "sans",
    header_font_family = "serif",
    outfile = path_to_css_file
  )

  library(ggplot2)
  ggplot(mpg) +
    aes(cty, hwy) +
    geom_point() +
    ggtitle("Fuel Efficiency of Various Cars") +
    # themed to match the inverse slides: teal background with dark blue text
    theme_xaringan_inverse()
}
}
\seealso{
Other xaringanthemer ggplot2 themes: 
\code{\link{theme_xaringan_base}()},
\code{\link{theme_xaringan_set_defaults}()},
\code{\link{theme_xaringan}()}
}
\concept{xaringanthemer ggplot2 themes}
