% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgpProblems.R
\name{NewEnvXOR}
\alias{NewEnvXOR}
\title{Generate the problem environment EnvXOR}
\usage{
NewEnvXOR()
}
\value{
The problem environment:
\itemize{
\item \code{$name}: The name of the problem environment.
\item \code{$f}:    The fitness function. 
                    For this environment number of correct test cases 
                    (correct function)
                    and the inverse of the number of terminal symbols
                    (boolean function with small number of elements). 
}
}
\description{
\code{NewEnvXOR()} generates the problem environment
             for the XOR-Problem.

 The problem environment provides an abstract interface
 to the simple genetic programming algorithm.
 \code{ProblemEnv$f(parm)} defines the function we want to optimize.

 A problem environment is a function factory with the following
 elements:

 \enumerate{
 \item
 \code{name()}   a string with the name of the environment
 \item
 \code{ProblemEnv$f(word)}
  function with word a word of the language (as text string).
 }

 Should be provided by the user as standard R-file.
}
\examples{
EnvXOR<-NewEnvXOR()
EnvXOR$name()
a2<-"OR(OR(D1, D2), (AND(NOT(D1), NOT(D2))))"
a3<-"OR(OR(D1, D2), AND(D1, D2))"
a4<-"AND(OR(D1,D2),NOT(AND(D1,D2)))"
gp4<-"(AND(AND(OR(D2,D1),NOT(AND(D1,D2))),(OR(D2,D1))))"
EnvXOR$f(a2)
EnvXOR$f(a3)
EnvXOR$f(a4)
EnvXOR$f(gp4)

}
\seealso{
Other Problem Environment: 
\code{\link{Parabola2DEarly}},
\code{\link{Parabola2D}},
\code{\link{lau15}}
}
\concept{Problem Environment}
