% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNF.R
\name{derive}
\alias{derive}
\title{Derives the identifier list which expands the non-terminal identifier.}
\usage{
derive(RuleIndex, RHS)
}
\arguments{
\item{RuleIndex}{An index (integer) in the production table.}

\item{RHS}{The right-hand side of the production table.}
}
\value{
A vector of numerical identifiers.
}
\description{
\code{derives()} returns the identifier list which expands 
             a non-terminal identifier.
              Warning: No error checking implemented.
}
\examples{
a<-booleanGrammar()$BNF
ST<-makeSymbolTable(a)
PT<-makeProductionTable(a,ST)
derive(1, PT$RHS)
derive(2, PT$RHS)
derive(3, PT$RHS)
derive(5, PT$RHS)

}
\seealso{
Other Utility Functions: 
\code{\link{id2symb}()},
\code{\link{isNonTerminal}()},
\code{\link{isTerminal}()},
\code{\link{rules}()},
\code{\link{symb2id}()}
}
\concept{Utility Functions}
