% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNF.R
\name{makeProductionTable}
\alias{makeProductionTable}
\title{Produces a production table.}
\usage{
makeProductionTable(BNF, ST)
}
\arguments{
\item{BNF}{A character string with the BNF.}

\item{ST}{A symbol table.}
}
\value{
A production table is a named list with elements 
        \code{$LHS} and \code{$RHS}:  
        \itemize{
        \item The left-hand side \code{LHS}
        of non-terminal identifiers. 
        \item The right-hand side \code{RHS} is represented as a 
        vector of vectors of numerical identifiers. 
        }
        The non-terminal identifier \code{LHS[i]} derives into \code{RHS[i]}.
}
\description{
\code{makeProductionTable()} produces a production table 
              from a specification of a BNF.   
              Warning: No error checking implemented.
}
\examples{
a<-booleanGrammar()$BNF
ST<-makeSymbolTable(a)
makeProductionTable(a,ST)

}
