% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfDecode.R
\name{xegaDfGeneMapIdentity}
\alias{xegaDfGeneMapIdentity}
\title{Map the parameter vector of a real-coded gene to an identical vector.}
\usage{
xegaDfGeneMapIdentity(gene, penv)
}
\arguments{
\item{gene}{Real-coded gene (the genotype).}

\item{penv}{Problem environment.}
}
\value{
Decoded gene (the phenotype).
}
\description{
\code{xegaDfGeneMapIdentity()} maps the real parameter vector
             to an identical vector.
}
\details{
A \emph{gene} is a list with 
         \enumerate{
         \item \code{$evaluated}: Boolean. TRUE if the fitness is known.
         \item \code{$fit}:       The fitness of the genotype of 
                                 \code{$gene1}.         
         \item \code{$gene1}:     A real parameter vector (the genotopye).
         }
}
\examples{
gene<-xegaDfInitGene(lFxegaDfGene)
xegaDfGeneMapIdentity(gene$gene1, lFxegaDfGene$penv)

}
\seealso{
Other Decoder: 
\code{\link{xegaDfDecodeGene}()}
}
\concept{Decoder}
