% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaReplicate.R
\name{xegaGaReplicate2Gene}
\alias{xegaGaReplicate2Gene}
\title{Replicates a gene.}
\usage{
xegaGaReplicate2Gene(pop, fit, lF)
}
\arguments{
\item{pop}{A population of binary genes.}

\item{fit}{Fitness vector.}

\item{lF}{The local configuration of the genetic algorithm.}
}
\value{
A list of either 1 or 2 binary genes.
}
\description{
\code{xegaGaReplicate2Gene} replicates a gene
             by applying a gene reproduction pipeline 
             which uses crossover and
             mutation. The control flow is as follows:
             \itemize{
             \item A gene is selected from the population.
             Check if the crossover operation should be applied.
             (The check is \code{TRUE} with a probability of \code{crossrate}).
             If the check is \code{TRUE}:
             \itemize{
               \item Select a mating gene from the population.
               \item Perform the crossover operation.
               \item Apply mutation with a probability of \code{mutrate}.
               \item Return a list with both genes.
                           }
               \item Apply mutation with a probability of \code{mutrate}.
               \item Return a list with a single gene.
             }
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCross2Gene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.001}
names(lFxegaGaGene)
pop10<-lapply(rep(0,10), function(x) xegaGaInitGene(lFxegaGaGene))
epop10<-lapply(pop10, lFxegaGaGene$EvalGene, lF=lFxegaGaGene)
fit10<-unlist(lapply(epop10, function(x) {x$fit}))
newgenes<-xegaGaReplicate2Gene(pop10, fit10, lFxegaGaGene)

}
\seealso{
Other Replication: 
\code{\link{xegaGaReplicateGene}()}
}
\concept{Replication}
