% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timer.R
\name{newCounter}
\alias{newCounter}
\title{Counter}
\usage{
newCounter()
}
\value{
\code{newCounter()} returns a counter function.

\code{a_counter_function()} returns the 
         number of times it has been called
        (invisible).

\code{a_counter_function("Show")} returns the number of executions
        of the \code{a_counter_function}.
}
\description{
\code{newCounter} sets up a counter object with one 
             internal state variable, namely \code{count} 
             to count the number of counter calls.
}
\details{
Generate a counter: 
            \code{a<-newCounter()} sets up the counter \code{a}.
            The counter \code{a} supports three methods:
      \enumerate{
       \item \code{a()} or 
             \code{a("Measure")} or 
             \code{a(method="Measure")} 
             \strong{starts} the timer when called 1st, 3rd, 5th, ... time
             and \strong{stops} the timer 
             when called the 2nd, 4th, 6th, ... time.
             The calls can be manually inserted 
             before and after a block of R-code for profiling.
       \item \code{a("Count")} or
             \code{a(method="Count")} returns the number of times 
             the function/block or R-code has been executed.
          }
}
\examples{
   a<-newCounter() 
   a(); a()
   a("Show")
}
\seealso{
Other Performance Measurement: 
\code{\link{Counted}()},
\code{\link{Timed}()},
\code{\link{newTimer}()}
}
\concept{Performance Measurement}
