% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlsx_cutter.R
\name{xlsx_cutter}
\alias{xlsx_cutter}
\title{Create a data.frame from a folder of non-rectangular excel files}
\usage{
xlsx_cutter(
  data_files,
  template_file,
  data_sheet = 1,
  template_sheet = 1,
  marker_open = "{{",
  marker_close = "}}"
)
}
\arguments{
\item{data_files}{vector of paths to the xlsx files to parse}

\item{template_file}{path to the template file to use as a model to parse the
xlsx files in \code{data_folder}}

\item{data_sheet}{sheet id to extract from the xlsx files}

\item{template_sheet}{sheet id of the template file to use as a model to
parse the xlsx files in \code{data_folder}}

\item{marker_open, marker_close}{character marker to mark the variables to
extract in the \code{template_file}}
}
\value{
A rectangular \code{data.frame} with columns as defined in the template.
Column types are determined automatically by \code{type.convert()}
}
\description{
Create a data.frame from a folder of non-rectangular excel files based on a
defined custom template
}
\examples{

data_files <- list.files(
  system.file("example", "timesheet", package = "xlcutter"),
  pattern = "\\\\.xlsx$",
  full.names = TRUE
)

template_file <- system.file(
  "example", "timesheet_template.xlsx",
  package = "xlcutter"
)

xlsx_cutter(
  data_files,
  template_file
)

}
