% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Transaction.R
\docType{data}
\name{Transaction}
\alias{Transaction}
\title{Transaction object.}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Transaction
}
\description{
An R6 class representing a transaction on the Stellar network.
    It is initialized from the getTransactionDetail() function.
}
\section{Fields}{

\describe{
\item{\code{ledger}}{- the sequence number of the ledger from which the transaction was confirmed.}

\item{\code{hash}}{- the cryptographic signature of the transaction (sha256)}

\item{\code{source_account}}{- the account that originates the transaction.}

\item{\code{created_at}}{- when the transaction was submited.}

\item{\code{fee_paid}}{- how much fee was paid (in stroops.)}

\item{\code{response}}{- list containing the raw JSON response.}
}}

\note{
https://www.stellar.org/developers/guides/concepts/transactions.html
}
\examples{
\dontrun{t = Transaction$new("afbe6f687c85d1f34ea18b73629be006518a2a3f5891760086340b4f1e834ccb")}
}
\keyword{datasets}
