library(xpectr)
context("initializeGXSFunctionAddin()")


test_that("testing initializeGXSFunctionAddin()", {

  # Generate expectations for 'initializeGXSFunctionAddin'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = initializeGXSFunctionAddin,
  #   args_values = list(
  #     "selection" = list("identity ", " initializeGXSFunctionAddin ", NA),
  #     "insert" = list(FALSE, NULL),
  #     "indentation" = list(0, 2, NULL)
  #   ), check_nulls = FALSE,
  #   indentation = 2
  # )

  ## Testing 'initializeGXSFunctionAddin'                                     ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing initializeGXSFunctionAddin(selection = "iden...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- initializeGXSFunctionAddin(selection = "identity ", insert = FALSE, indentation = 0)
  # Testing class
  expect_equal(
    class(output_19148),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "character")
  # Testing values
  expect_equal(
    output_19148,
    c(
      "# Generate expectations for 'identity'",
      "# Tip: comment out the gxs_function() call",
      "# so it is easy to regenerate the tests",
      "xpectr::set_test_seed(42)",
      "xpectr::gxs_function(",
      "  fn = identity,",
      "  args_values = list(\n",
      "    \"x\" = list()",
      "  ),",
      "  indentation = 2",
      ")",
      " ",
      "#"
    ),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    13L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    13L)

  # Testing initializeGXSFunctionAddin(selection = " ini...
  # Changed from baseline: selection = " initial...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- initializeGXSFunctionAddin(selection = " initializeGXSFunctionAddin ", insert = FALSE, indentation = 0)
  # Testing class
  expect_equal(
    class(output_19370),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19370,
    type = "character")
  # Testing values
  expect_equal(
    output_19370,
    c(
      "# Generate expectations for 'initializeGXSFunctionAddin'",
      "# Tip: comment out the gxs_function() call",
      "# so it is easy to regenerate the tests",
      "xpectr::set_test_seed(42)",
      "xpectr::gxs_function(",
      "  fn = initializeGXSFunctionAddin,",
      "  args_values = list(\n",
      "    \"selection\" = list(NULL),",
      "    \"insert\" = list(TRUE),",
      "    \"indentation\" = list(0)",
      "  ),",
      "  indentation = 2",
      ")",
      " ",
      "#"
    ),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_19370),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19370),
    15L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19370)),
    15L)

  # Testing initializeGXSFunctionAddin(selection = NA, i...
  # Changed from baseline: selection = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(initializeGXSFunctionAddin(selection = NA, insert = FALSE, indentation = 0), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'selection': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing initializeGXSFunctionAddin(selection = "iden...
  # Changed from baseline: insert = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(initializeGXSFunctionAddin(selection = "identity ", insert = NULL, indentation = 0), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'insert': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing initializeGXSFunctionAddin(selection = "iden...
  # Changed from baseline: indentation = 2
  xpectr::set_test_seed(42)
  # Assigning output
  output_15190 <- initializeGXSFunctionAddin(selection = "identity ", insert = FALSE, indentation = 2)
  # Testing class
  expect_equal(
    class(output_15190),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_15190,
    type = "character")
  # Testing values
  expect_equal(
    output_15190,
    c("# Generate expectations for 'identity'", "# Tip: comment out the gxs_function() call",
      "# so it is easy to regenerate the tests", "xpectr::set_test_seed(42)",
      "xpectr::gxs_function(", "  fn = identity,", "  args_values = list(\n",
      "    \"x\" = list()", "  ),", "  indentation = 2", ")", " ",
      "#"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_15190),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_15190),
    13L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_15190)),
    13L)

  # Testing initializeGXSFunctionAddin(selection = "iden...
  # Changed from baseline: indentation = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- initializeGXSFunctionAddin(selection = "identity ", insert = FALSE, indentation = NULL)
  # Testing class
  expect_equal(
    class(output_17365),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17365,
    type = "character")
  # Testing values
  expect_equal(
    output_17365,
    c(
      "# Generate expectations for 'identity'",
      "# Tip: comment out the gxs_function() call",
      "# so it is easy to regenerate the tests",
      "xpectr::set_test_seed(42)",
      "xpectr::gxs_function(",
      "  fn = identity,",
      "  args_values = list(\n",
      "    \"x\" = list()",
      "  ),",
      "  indentation = 2",
      ")",
      " ",
      "#"
    ),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_17365),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_17365),
    13L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_17365)),
    13L)

  ## Finished testing 'initializeGXSFunctionAddin'                            ####
  #

})
