% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_label.R
\name{xportr_df_label}
\alias{xportr_df_label}
\title{Assign Dataset Label}
\usage{
xportr_df_label(.df, metacore, domain = NULL)
}
\arguments{
\item{.df}{A data frame of CDISC standard.}

\item{metacore}{A data frame containing dataset level metadata.}

\item{domain}{A character value to subset the \code{.df}. If \code{NULL}(default), uses
\code{.df} value as a subset condition.}
}
\value{
Data frame with label attributes.
}
\description{
Assigns dataset label from a dataset level metadata to a given data frame.
}
\examples{
adsl <- data.frame(
  USUBJID = c(1001, 1002, 1003),
  SITEID = c(001, 002, 003),
  AGE = c(63, 35, 27),
  SEX = c("M", "F", "M")
)

metacore <- data.frame(
  dataset = c("adsl", "adae"),
  label = c("Subject-Level Analysis", "Adverse Events Analysis")
)

adsl <- xportr_df_label(adsl, metacore)
}
\seealso{
\code{\link[=xportr_label]{xportr_label()}}, \code{\link[=xportr_format]{xportr_format()}} and \code{\link[=xportr_length]{xportr_length()}}

Other metadata functions: 
\code{\link{xportr_format}()},
\code{\link{xportr_label}()},
\code{\link{xportr_length}()}
}
\concept{metadata functions}
