% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical.R
\name{list_dv_probs}
\alias{list_dv_probs}
\title{For a categorical DV variable, show associated probabilities}
\usage{
list_dv_probs(xpdb, .problem = NULL, .dv_var = NULL)
}
\arguments{
\item{xpdb}{<\code{xp_xtras}> object}

\item{.problem}{<\code{numeric}> Problem number to use. Uses the all problems if \code{NULL}}

\item{.dv_var}{<\code{tidyselect}> of column having the categorical observation. Default is first-listed
\code{catdv}.}
}
\value{
<\code{tibble}> of probabilities
}
\description{
A convenient quick check for how probabilities are currently
assigned, based on \code{\link{set_dv_probs}}.
}
\examples{

pkpd_m3 \%>\%
  set_dv_probs(1, 1~LIKE, .dv_var = BLQ) \%>\%
  list_dv_probs(.dv_var=BLQ)

}
