% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nm_model.R
\name{read_nm_model}
\alias{read_nm_model}
\title{NONMEM model file parser}
\usage{
read_nm_model(runno = NULL, prefix = "run", ext = ".lst",
  file = NULL, dir = NULL)
}
\arguments{
\item{runno}{Run number to be used to generate model file name. Used in
combination with \code{prefix} and \code{ext}.}

\item{prefix}{Prefix to be used to generate model file name. Used in
combination with \code{runno} and \code{ext}.}

\item{ext}{Extension to be used to generate model file name.Should be one of
'.lst' (default), '.out', '.res', '.mod' or '.ctl' for NONMEM.}

\item{file}{Model file name (preferably a '.lst' file) containing the file
extension. Alternative to \code{prefix}, \code{runno} and \code{ext}
arguments.}

\item{dir}{Location of the model files.}
}
\value{
A \code{\link[dplyr]{tibble}} of class \code{model} containing the following columns: 
\itemize{
 \item{\strong{problem}}{: a numeric identifier for the $PROBLEM associated with the code.}
 \item{\strong{level}}{: a unique numeric identifier to each subroutine block associated with the code.}
 \item{\strong{subroutine}}{: a character identifier named after the 3 first letters of the subroutine name e.g. '$THETA' and 
 '$TABLE' will become 'the' and 'tab' respectively. In addition all output from the .lst is labeled 'lst', the general nonmem 
 output e.g. NM-TRAN messages are labelled 'oth'. With priors thp, tpv, omp, opd, sip, spd abbreviations are given to the THETAP, 
 THETAPV, OMEGAP, etc.}
 \item{\strong{code}}{: the code without comments or subroutine names e.g. '$THETA 0.5 ; TVCL' will return '0.5'.}
 \item{\strong{comment}}{: the last comment of a record e.g. '0.5 ; Clearance (L/h) ; TVCL' will return 'TVCL'.}
}
}
\description{
Parse NONMEM model files in R format
}
\details{
A NONMEM model output file (i.e. .lst, .out or .res) should preferably be provided to \code{read_nm_model} to allow for a more extensive xpose 
summary. However in some cases these output files may not contain the model code, thus preventing xpose from identifying the associated output 
tables names. In such cases xpose will attempt to read the associated model file (i.e. .mod or .ctl) instead to find the model code. Note: it 
is important that between the naming convention between the NONMEM output and the model file remains consistent e.g. run001.lst should be 
associated with run001.mod.
}
\section{File path generation}{
 The rules for model file names generation are
  as follow: \itemize{ 
  \item with \code{runno}: the full path is generated as
  \code{<dir>/<prefix><runno>.<ext>} e.g. with \code{dir = 'model/pk'},
  \code{prefix = 'run'}, \code{runno = '001'}, \code{ext = '.lst'} the
  resulting path would be \code{model/pk/run001.lst} 
  \item with \code{file}:
  the full path is generated as \code{<dir>/<file>} e.g. with \code{dir =
  'model/pk'}, \code{file = 'run001.lst'} the resulting path would also be
  \code{model/pk/run001.lst}. Note: in this case the file extension should be
  provided as part of the `file` argument.
  }
}

\examples{
\dontrun{
# Using the `file` argument to import a model file:
nm_model <- read_nm_model(file = 'run001.lst', dir = 'models')

# Using the `runno` argument to import a model file:
nm_model <- read_nm_model(runno = '001', ext = '.lst', dir = 'models')
}

}
\seealso{
\code{\link{xpose_data}}, \code{\link{read_nm_tables}}
}
