% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov.qq.R, R/parm.qq.R, R/ranpar.qq.R
\name{par_cov_qq}
\alias{par_cov_qq}
\alias{cov.qq}
\alias{parm.qq}
\alias{ranpar.qq}
\title{Plot the parameter or covariate distributions using quantile-quantile (Q-Q)
plots}
\usage{
cov.qq(object, onlyfirst = TRUE, main = "Default", ...)

parm.qq(object, onlyfirst = TRUE, main = "Default", ...)

ranpar.qq(object, onlyfirst = TRUE, main = "Default", ...)
}
\arguments{
\item{object}{An xpose.data object.}

\item{onlyfirst}{Logical value indicating if only the first row per
individual is included in the plot.}

\item{main}{The title of the plot.  If \code{"Default"} then a default title
is plotted. Otherwise the value should be a string like \code{"my title"} or
\code{NULL} for no plot title.}

\item{\dots}{Other arguments passed to \code{\link{xpose.plot.qq}}.}
}
\value{
Delivers a stack of Q-Q plots.
}
\description{
These functions plot the parameter or covariate values stored in an Xpose
data object using Q-Q plots.
}
\details{
Each of the parameters or covariates in the Xpose data object, as specified
in \code{object@Prefs@Xvardef$parms}, \code{object@Prefs@Xvardef$ranpar} or
\code{object@Prefs@Xvardef$covariates}, is evaluated in turn, creating a
stack of Q-Q plots.

A wide array of extra options controlling Q-Q plots are available. See
\code{\link{xpose.plot.qq}} for details.
}
\section{Functions}{
\itemize{
\item \code{cov.qq}: Covariate distributions

\item \code{parm.qq}: parameter distributions

\item \code{ranpar.qq}: random parameter distributions
}}

\examples{

## Here we load the example xpose database 
xpdb <- simpraz.xpdb

## parameter histograms
parm.qq(xpdb)

## A stack of random parameter histograms
ranpar.qq(xpdb)

## Covariate distribution, in green with red line of identity
cov.qq(xpdb, col=11, ablcol=2)

}
\seealso{
\code{\link{xpose.plot.qq}}, \code{\link{xpose.panel.qq}},
\code{\link[lattice]{qqmath}}, \code{\link{xpose.data-class}},
\code{\link{xpose.prefs-class}}

Other specific functions: \code{\link{absval.cwres.vs.cov.bw}},
  \code{\link{absval.cwres.vs.pred.by.cov}},
  \code{\link{absval.cwres.vs.pred}},
  \code{\link{absval.iwres.cwres.vs.ipred.pred}},
  \code{\link{absval.iwres.vs.cov.bw}},
  \code{\link{absval.iwres.vs.idv}},
  \code{\link{absval.iwres.vs.ipred.by.cov}},
  \code{\link{absval.iwres.vs.ipred}},
  \code{\link{absval.iwres.vs.pred}},
  \code{\link{absval.wres.vs.cov.bw}},
  \code{\link{absval.wres.vs.idv}},
  \code{\link{absval.wres.vs.pred.by.cov}},
  \code{\link{absval.wres.vs.pred}},
  \code{\link{absval_delta_vs_cov_model_comp}},
  \code{\link{addit.gof}}, \code{\link{autocorr.cwres}},
  \code{\link{autocorr.iwres}},
  \code{\link{autocorr.wres}}, \code{\link{basic.gof}},
  \code{\link{basic.model.comp}},
  \code{\link{cat.dv.vs.idv.sb}}, \code{\link{cat.pc}},
  \code{\link{cov.splom}}, \code{\link{cwres.dist.hist}},
  \code{\link{cwres.dist.qq}}, \code{\link{cwres.vs.cov}},
  \code{\link{cwres.vs.idv.bw}},
  \code{\link{cwres.vs.idv}},
  \code{\link{cwres.vs.pred.bw}},
  \code{\link{cwres.vs.pred}},
  \code{\link{cwres_wres_vs_x}}, \code{\link{dOFV.vs.cov}},
  \code{\link{dOFV.vs.id}}, \code{\link{dOFV1.vs.dOFV2}},
  \code{\link{data.checkout}},
  \code{\link{dv.preds.vs.idv}}, \code{\link{dv.vs.idv}},
  \code{\link{dv.vs.ipred.by.cov}},
  \code{\link{dv.vs.ipred.by.idv}},
  \code{\link{dv.vs.ipred}},
  \code{\link{dv.vs.pred.by.cov}},
  \code{\link{dv.vs.pred.by.idv}},
  \code{\link{dv.vs.pred.ipred}}, \code{\link{dv.vs.pred}},
  \code{\link{gof}}, \code{\link{ind.plots.cwres.hist}},
  \code{\link{ind.plots.cwres.qq}},
  \code{\link{ind.plots}}, \code{\link{ipred.vs.idv}},
  \code{\link{iwres.dist.hist}},
  \code{\link{iwres.dist.qq}}, \code{\link{iwres.vs.idv}},
  \code{\link{kaplan.plot}}, \code{\link{par_cov_hist}},
  \code{\link{parm.vs.cov}}, \code{\link{parm.vs.parm}},
  \code{\link{pred.vs.idv}}, \code{\link{ranpar.vs.cov}},
  \code{\link{runsum}}, \code{\link{wres.dist.hist}},
  \code{\link{wres.dist.qq}}, \code{\link{wres.vs.idv.bw}},
  \code{\link{wres.vs.idv}}, \code{\link{wres.vs.pred.bw}},
  \code{\link{wres.vs.pred}}, \code{\link{xpose.VPC.both}},
  \code{\link{xpose.VPC.categorical}},
  \code{\link{xpose.VPC}}, \code{\link{xpose4-package}}
}
\author{
Andrew Hooker & Justin Wilkins
}
\keyword{methods}
