% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module2_estimation.R
\name{estimate_people}
\alias{estimate_people}
\alias{estimate_people_3pl_eap}
\alias{estimate_people_3pl_map}
\alias{estimate_people_3pl_mle}
\title{Estimate People Parameters}
\usage{
estimate_people(responses, items, model = c("3pl"), method = c("mle", "eap",
  "map"), ...)

estimate_people_3pl_mle(responses, items, init = 0, iter = 30,
  conv = 0.01, bound = 3.5, debug = FALSE)

estimate_people_3pl_map(responses, items, prior.mean = 0, prior.sd = 1,
  init = 0, iter = 30, conv = 0.01, bound = 3.5, debug = FALSE)

estimate_people_3pl_eap(responses, items)
}
\arguments{
\item{responses}{a data frame or matrix of responses}

\item{items}{a data frame of item parameters}

\item{model}{the IRT model}

\item{method}{the estimation method}

\item{...}{further arguments}

\item{init}{initial values of people parameters, a number or a vector}

\item{iter}{the maximum of Newton-Raphson iterations}

\item{conv}{convergence criterion}

\item{bound}{the bounds of estimated people parameters}

\item{debug}{\code{TRUE} to turn on debugging mode}

\item{prior.mean}{the mean of the prior distribuiton}

\item{prior.sd}{the standard deviation of the prior distribution}
}
\value{
a data frame of estimated people parameters
}
\description{
Estimate people parameters when item parameters are known

\code{estimate_people_3pl_mle} is the maximum likelihood (ML) estimator of the people parameter.

\code{estimate_people_3pl_map} is the maximum a posteriori (MAP) estimator of people parameters

\code{estimate_people_3pl_eap} is the expected a priori (EAP) estimator of people parameters
}
\details{
The debug mode draws a convergence curve. \cr
For the maximum likelihood (ML) estimation, refer to Baker and Kim (2004), pp. 66-69.

For the maximum a posteriori (MAP) estimation, refer to Baker and Kim (2004), pp. 192.

For the expected a priori (EAP), refer to Baker and Kim (2004), pp. 193.
}
\examples{
\dontrun{
# data generation
library(ggplot2)
library(reshape2)
library(dplyr)
data <- irt_model("3pl")$gendata(500, 50)

# Estimate people parameters: MLE
x.mle <- estimate_people(data$responses, data$items, "3pl", "mle")
# Estimate people parameters: MAP
x.map <- estimate_people(data$responses, data$items, "3pl", "map")
# Estimate people parameters: EAP
x.eap <- estimate_people(data$responses, data$items, "3pl", "eap")
# Comparison with true parameters
x <- data.frame(true=data$people$theta, mle=x.mle$people$theta, 
  map=x.map$people$theta, eap=x.eap$people$theta)
round(t(apply(x, 2, function(v) c(R=cor(v, x$true), RMSE=rmse(v, x$true)))), 2)
melt(x, id.vars="true") \%>\% 
  ggplot(aes(x=true, y=value, color=variable)) + geom_point(pch=1) +
  facet_wrap(~variable, nrow=2) + xlab("True") + ylab("Est.") +
  theme_bw() + theme(legend.key=element_blank())
}
}

