% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module0_model_3pl.R
\name{model_3pl}
\alias{model_3pl}
\title{3PL Model}
\usage{
model_3pl(people = NULL, items = NULL, responses = NULL, theta = NULL,
  a = NULL, b = NULL, c = NULL)
}
\arguments{
\item{people}{a data frame of \code{theta} parameters}

\item{items}{a data frame of \code{a}, \code{b}, \code{c} parameters}

\item{responses}{a data frame or a matrix of dichotomous responses}

\item{theta}{a vector of \code{theta} parameters}

\item{a}{a vector of \code{a} parmaeters}

\item{b}{a vector of \code{b} parmaeters}

\item{c}{a vector of \code{c} parmaeters}
}
\description{
Create a 3PL model object
}
\details{
A 3pl model contains \code{people} (peoeple parameters), \code{items} (item parameters),
\code{responses} (responses data), and functions to compute \code{P} (probability),
\code{I} (information), and \code{L} (likelihood). \cr
Inputs are allowed to be \code{NULL}. When necessary parameters are null, a function returns an error. 
All arguments in \code{irt.model.3pl} are allowed to be \code{NULL}. The \code{people} argument needs to be
a one-column data frame or a data frame with a column named theta. The \code{items} argument needs to be
a three-column data frame or a data frame with columns named a, b, and c. The \code{responses} argument needs
to be a data frame or matrix whose dimensions match the dimension of \code{people} and \code{items}.
}
\examples{
# create a 3pl model using given parameters
theta <- c(-1, 0, 1)
a <- c(.5882, 1)
b <- c(-1, 1)
c <- c(0, .2)
u <- matrix(c(1, 0, 1, 0, 1, 0), nrow=3)
people <- data.frame(theta=theta)
items <- data.frame(a=a, b=b, c=c)
model_3pl(people=people, items=items, responses=u) 
model_3pl(people=people, items=items) 
model_3pl(theta=theta, a=a, b=b, c=c) 
model_3pl(people=people, a=a, b=b, c=c) 
model_3pl(theta=theta, items=items) 
# compute P(robability), I(nformation), L(ikelihood)
x <- model_3pl(people=people, items=items, responses=u)
x$P(x)
x$I(x)
x$L(x)
model_3pl()$P(x)
model_3pl()$I(x)
model_3pl()$L(x)
# create a 3pl model using generated data
x <- model_3pl()$gendata(10, 5)
x
x$P(x)
x$I(x)
x$L(x)
}

