% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grnn.search_rsq.R
\name{grnn.search_rsq}
\alias{grnn.search_rsq}
\title{Search for the optimal value of GRNN smoothing parameter based on r-square}
\usage{
grnn.search_rsq(net, sigmas, nfolds = 4, seed = 1)
}
\arguments{
\item{net}{A GRNN object generated by grnn.fit()}

\item{sigmas}{A numeric vector to search for the best smoothing parameter}

\item{nfolds}{A scalar for the number of n-fold, 4 by default}

\item{seed}{The seed value for the n-fold cross-validation, 1 by default}
}
\value{
The list of all searching outcomes and the best outcome
}
\description{
The function \code{grnn.search_rsq} searches for the optimal value of GRNN smoothing parameter by cross-validation.
It is applicable to the functional approximation
}
\examples{
data(iris, package = "datasets")
Y <- ifelse(iris[, 5] == "setosa", 1, 0)
X <- scale(iris[, 1:4])
gnet <- grnn.fit(x = X, y = Y)
grnn.search_rsq(net = gnet, sigmas = seq(3), nfolds = 2)
}
