% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singularity.R
\name{[.decorated}
\alias{[.decorated}
\title{Subset Decorated}
\usage{
\method{[}{decorated}(x, ..., .promote = getOption("yamlet_promote", TRUE))
}
\arguments{
\item{x}{object to subset}

\item{...}{passed to next method}

\item{.promote}{whether to auto-promote plural attributes}
}
\value{
decorated
}
\description{
Subsets decorated. Calls \code{\link{promote}}
internally to improve ambiguous conditional
attributes where possible.
}
\examples{
library(magrittr)
file <- system.file(package = 'yamlet', 'extdata','phenobarb.csv')
x <- file \%>\% decorate
x \%>\% decorations(event, value)

# Subsetting promotes automatically.
x[x$event == 'dose',] \%>\% decorations(event, value)
x[x$event == 'conc',] \%>\% decorations(event, value)
}
\seealso{
Other promote: 
\code{\link{filter.decorated}()},
\code{\link{promote.default}()},
\code{\link{promote}()},
\code{\link{singularity}()}
}
\concept{promote}
\keyword{internal}
