% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnn.predone.R
\name{pnn.predone}
\alias{pnn.predone}
\title{Calculate the predicted probability for each category of PNN}
\usage{
pnn.predone(net, x)
}
\arguments{
\item{net}{A PNN object created by pnn.fit()}

\item{x}{A vector of input predictors}
}
\value{
A one-row matrix of predicted probabilities
}
\description{
The function \code{pnn.predone} calculates the predicted probability for each category of PNN
}
\examples{
data(iris, package = "datasets")
Y <- iris[, 5]
X <- scale(iris[, 1:4])
pnet <- pnn.fit(x = X, y = Y)
for (i in seq(5)) print(pnn.predone(pnet, X[i, ]))
}
\seealso{
\code{\link{pnn.fit}}
}
