% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-j_index.R
\name{j_index}
\alias{j_index}
\alias{j_index.data.frame}
\alias{j_index_vec}
\title{J-index}
\usage{
j_index(data, ...)

\method{j_index}{data.frame}(
  data,
  truth,
  estimate,
  estimator = NULL,
  na_rm = TRUE,
  event_level = yardstick_event_level(),
  ...
)

j_index_vec(
  truth,
  estimate,
  estimator = NULL,
  na_rm = TRUE,
  event_level = yardstick_event_level(),
  ...
)
}
\arguments{
\item{data}{Either a \code{data.frame} containing the \code{truth} and \code{estimate}
columns, or a \code{table}/\code{matrix} where the true class results should be
in the columns of the table.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true class results
(that is a \code{factor}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:nse-force]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{factor} vector.}

\item{estimate}{The column identifier for the predicted class
results (that is also \code{factor}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{factor} vector.}

\item{estimator}{One of: \code{"binary"}, \code{"macro"}, \code{"macro_weighted"},
or \code{"micro"} to specify the type of averaging to be done. \code{"binary"} is
only relevant for the two class case. The other three are general methods
for calculating multiclass metrics. The default will automatically choose
\code{"binary"} or \code{"macro"} based on \code{estimate}.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{event_level}{A single string. Either \code{"first"} or \code{"second"} to specify
which level of \code{truth} to consider as the "event". This argument is only
applicable when \code{estimator = "binary"}. The default uses an
internal helper that generally defaults to \code{"first"}, however, if the
deprecated global option \code{yardstick.event_first} is set, that will be
used instead with a warning.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{j_index_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
Youden's J statistic is defined as:

\code{\link[=sens]{sens()}} + \code{\link[=spec]{spec()}} - 1

A related metric is Informedness, see the Details section for the relationship.
}
\details{
The value of the J-index ranges from [0, 1] and is \code{1} when there are
no false positives and no false negatives.

The binary version of J-index is equivalent to the binary concept of
Informedness. Macro-weighted J-index is equivalent to multiclass informedness
as defined in Powers, David M W (2011), equation (42).
}
\section{Relevant Level}{


There is no common convention on which factor level should
automatically be considered the "event" or "positive" result
when computing binary classification metrics. In \code{yardstick}, the default
is to use the \emph{first} level. To alter this, change the argument
\code{event_level} to \code{"second"} to consider the \emph{last} level of the factor the
level of interest. For multiclass extensions involving one-vs-all
comparisons (such as macro averaging), this option is ignored and
the "one" level is always the relevant result.
}

\section{Multiclass}{


Macro, micro, and macro-weighted averaging is available for this metric.
The default is to select macro averaging if a \code{truth} factor with more
than 2 levels is provided. Otherwise, a standard binary calculation is done.
See \code{vignette("multiclass", "yardstick")} for more information.
}

\examples{
# Two class
data("two_class_example")
j_index(two_class_example, truth, predicted)

# Multiclass
library(dplyr)
data(hpc_cv)

hpc_cv \%>\%
  filter(Resample == "Fold01") \%>\%
  j_index(obs, pred)

# Groups are respected
hpc_cv \%>\%
  group_by(Resample) \%>\%
  j_index(obs, pred)

# Weighted macro averaging
hpc_cv \%>\%
  group_by(Resample) \%>\%
  j_index(obs, pred, estimator = "macro_weighted")

# Vector version
j_index_vec(
  two_class_example$truth,
  two_class_example$predicted
)

# Making Class2 the "relevant" level
j_index_vec(
  two_class_example$truth,
  two_class_example$predicted,
  event_level = "second"
)
}
\references{
Youden, W.J. (1950). "Index for rating diagnostic tests". Cancer. 3: 32-35.

Powers, David M W (2011). "Evaluation: From Precision, Recall and F-Score to
ROC, Informedness, Markedness and Correlation". Journal of Machine Learning
Technologies. 2 (1): 37-63.
}
\seealso{
Other class metrics: 
\code{\link{accuracy}()},
\code{\link{bal_accuracy}()},
\code{\link{detection_prevalence}()},
\code{\link{f_meas}()},
\code{\link{kap}()},
\code{\link{mcc}()},
\code{\link{npv}()},
\code{\link{ppv}()},
\code{\link{precision}()},
\code{\link{recall}()},
\code{\link{sens}()},
\code{\link{spec}()}
}
\author{
Max Kuhn
}
\concept{class metrics}
