% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{selectInput}
\alias{selectInput}
\alias{updateSelectInput}
\alias{groupSelectInput}
\alias{updateGroupSelectInput}
\title{Select inputs}
\usage{
selectInput(id, choices = NULL, values = choices,
  selected = values[[1]], ...)

updateSelectInput(id, choices = NULL, values = choices,
  selected = NULL, enable = NULL, disable = NULL, valid = NULL,
  invalid = NULL, session = getDefaultReactiveDomain())

groupSelectInput(id, choices, values = choices, selected = values[[1]],
  ..., left = NULL, right = NULL)

updateGroupSelectInput(id, choices = NULL, values = choices,
  selected = NULL, enable = NULL, disable = NULL, valid = NULL,
  invalid = NULL, session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{A character string specifying the id of the reactive input.}

\item{choices}{A character vector specifying the input's choices.}

\item{values}{A character vector specifying the values of the input's
choices, defaults to \code{choices}.}

\item{selected}{One of \code{values} indicating the default value of the input,
defaults to \code{values[[1]]}.}

\item{...}{Additional named arguments passed as HTML attributes to the
parent element or tag elements passed as child elements to the parent
element.}

\item{enable}{One of \code{values} specifying particular choices to enable or
\code{TRUE} specifying the entire input is enabled, defaults to \code{NULL}.}

\item{disable}{One of \code{values} specifying particular choices to disable or
\code{TRUE} specifying the entire input is disabled, defaults to \code{NULL}.}

\item{valid}{A character string specifying a message to the user indicating
how the input's value is valid, defaults to \code{NULL.}}

\item{invalid}{A character string specifying a message to the user
indicating how the input's value is invalid, defaults to \code{NULL}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}

\item{left, right}{A character vector specifying static addons or
\code{\link[=buttonInput]{buttonInput()}} or \code{\link[=dropdown]{dropdown()}} elements specifying dynamic addons. Addons
affect the reactive value of the group input, see the Details section below
for more information.

\strong{\code{left} is character or \code{right} is character}

If \code{left} or \code{right} are character vectors, then the group input functions
like a text input. The value will update and trigger a reactive event when
the text box is modified. The group input's reactive value is the
concatention of the static addons specified by \code{left} or \code{right} and the
value of the text input.

\strong{\code{left} is button or \code{right} is button}

The button does not change the value of the group input. However, the input
no longer triggers event when the text box is updated. Instead the value is
updated when a button is clicked. Static addons are still applied to the
group input value.

\strong{\code{left} is a dropdown or \code{right} is a dropdown}

The value of the group input does chance depending on the clicked dropdown
menu item. The value of the input group is the concatentation of the
dropdown input value, the value of the text input, and any static addons.}
}
\description{
Create a select input. Select elements typically appear as a simple menu of
choices and may have one or more selected values, see the \code{multiple}
argument. A group select input is a select input with one or two additional
components. These addon components are used to change the reactivity or value
of the input, see Details for more information.
}
\examples{

### Simple select input

selectInput(
  id = "select1",
  choices = c(
    "Choice 1",
    "Choice 2",
    "Choice 3"
  ),
  values = list(1, 2, 3)
)

### Group select input

groupSelectInput(
  id = "select2",
  choices = 1:5,
  left = "$",
  right = ".00"
) \%>\%
  width(10)

}
\seealso{
Other inputs: \code{\link{buttonGroupInput}},
  \code{\link{buttonInput}}, \code{\link{checkbarInput}},
  \code{\link{checkboxInput}}, \code{\link{chipInput}},
  \code{\link{fileInput}}, \code{\link{formInput}},
  \code{\link{listGroupInput}}, \code{\link{menuInput}},
  \code{\link{navInput}}, \code{\link{radioInput}},
  \code{\link{radiobarInput}}, \code{\link{rangeInput}},
  \code{\link{textInput}}
}
\concept{inputs}
