% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/badge.R
\name{badge}
\alias{badge}
\title{Badges}
\usage{
badge(...)
}
\arguments{
\item{...}{Named arguments passed as HTML attributes to the parent
element or tag elements passed as children to the parent element.}
}
\description{
Small highlighted content which scales to its parent's size. A badge may
be dynamically updated with \code{\link[=replaceContent]{replaceContent()}}, in which case be sure to
pass an \code{id} argument as part of \code{...}.
}
\section{Example application}{
\preformatted{ui <- container(
  buttonInput(
    id = "clicker",
    label = list(
      "Clicks",
      badge(id = "counter") \%>\%
        margin(left = 2) \%>\%
        background("teal")
    )
  )
)

server <- function(input, output) {
  observe({
    clicks <- if (is.null(input$clicker)) 0 else input$clicker
    replaceContent("counter", clicks)
  })
}

shinyApp(ui, server)
}
}

\examples{

### Possible colors

colors <- c(
  "red", "purple", "indigo", "blue", "cyan", "teal", "green",
  "yellow", "amber", "orange", "grey", "white"
)

div(
  lapply(colors, function(color) {
    badge(color) \%>\%
      background(color) \%>\%
      margin(2) \%>\%
      padding(1)
  })
) \%>\%
  display("flex") \%>\%
  flex(wrap = TRUE)

}
\seealso{
Other components: \code{\link{alert}},
  \code{\link{blockquote}}, \code{\link{card}},
  \code{\link{collapsePane}}, \code{\link{d1}},
  \code{\link{dropdown}}, \code{\link{img}},
  \code{\link{jumbotron}}, \code{\link{modal}},
  \code{\link{navContent}}, \code{\link{popover}},
  \code{\link{pre}}, \code{\link{toast}}
}
\concept{components}
