% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropdown.R
\name{dropdown}
\alias{dropdown}
\title{Dropdown menus}
\usage{
dropdown(label, ..., direction = "down", align = "left")
}
\arguments{
\item{label}{A character string specifying the label of the dropdown's
button.}

\item{...}{Character strings or vectors, header tag elements, button inputs,
or form inputs specifying the elements of the dropdown. These elements may
be grouped into lists to create a menu with sections. \code{h6()} is the
recommended heading level for menu headers. Character vectors are converted
into paragraphs of text. To format menu text use \code{p()} and utility
functions.

Additional named arguments are passed as HTML attributes to the parent
element.}

\item{direction}{One of \code{"up"}, \code{"right"}, \code{"down"}, or \code{"left"} specifying
the direction in which the menu opens, defaults to \code{"down"}.}

\item{align}{One of \code{"left"} or \code{"right"} specifying which side of the button
to align the dropdown menu to, defaults to \code{"left"}.}
}
\description{
Dropdown menus are a container for buttons, text, and form inputs. See
argument \code{...} for details on composing dropdown menus.
}
\examples{

### Dropdown with buttons

dropdown(
  label = "Choices",
  buttonInput("choice1", "Choice 1"),
  buttonInput("choice2", "Choice 2"),
  buttonInput("choice3", "Choice 3")
)

### Dropdown with links

dropdown(
  label = "Choices",
  linkInput("link1", "Choice 1"),
  linkInput("link2", "Choice 2")
)

### Grouped sections

dropdown(
  label = "Sections",
  h6("Section 1"),
  buttonInput("a", "Option A"),
  buttonInput("b", "Option B"),
  hr(),
  h6("Section 2"),
  buttonInput("c", "Option C"),
  buttonInput("d", "Option D")
)

### Direction variations

dropdown(
  label = "Up!",
  direction = "up",
  buttonInput("up1", "Choice 1"),
  buttonInput("up2", "Choice 2")
)

### Dropdowns with forms

dropdown(
  label = "Sign in",
  formInput(
    id = "login",
    formGroup(
      label = "Username / Email",
      textInput(
        type = "email",
        id = "user"
      )
    ),
    formGroup(
      label = "Password",
      textInput(
        type = "password",
        id = "pass"
      )
    ),
    formSubmit(
      label = "Sign in",
      value = "signin"
    )
  ) \%>\%
    padding(3, 4, 3, 4)
)

}
\seealso{
Other components: \code{\link{alert}}, \code{\link{badge}},
  \code{\link{blockquote}}, \code{\link{card}},
  \code{\link{collapsePane}}, \code{\link{d1}},
  \code{\link{img}}, \code{\link{jumbotron}},
  \code{\link{modal}}, \code{\link{navContent}},
  \code{\link{popover}}, \code{\link{pre}},
  \code{\link{toast}}
}
\concept{components}
