% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{affix}
\alias{affix}
\title{Position}
\usage{
affix(tag, position)
}
\arguments{
\item{tag}{A tag element.}

\item{position}{One of \code{"top"}, \code{"bottom"}, or \code{"sticky"} specifying the
fixed behavior of an element.}
}
\description{
The \code{affix} utility function applies Bootstrap classes to fix elements to the
top or bottom of a page. Use \code{"sticky"} to cause an element to fix to the top
of a page after the element is scrolled past. \emph{Important}, the IE11 and
Edge browsers do not support the sticky behavior.
}
\examples{

### Affix an element

div(
  span("I'm up here!") \%>\%
    padding(left = 3, right = 3) \%>\%
    background("teal")
) \%>\%
  display("flex") \%>\%
  flex(justify = "center") \%>\%
  affix("top")

}
\seealso{
Other design utilities: 
\code{\link{active}()},
\code{\link{background}()},
\code{\link{border}()},
\code{\link{display}()},
\code{\link{float}()},
\code{\link{font}()},
\code{\link{height}()},
\code{\link{padding}()},
\code{\link{scroll}()},
\code{\link{shadow}()},
\code{\link{width}()}
}
\concept{design utilities}
