% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBatsmenvsBowlersAllOppnAllMatchesPlot.R
\name{teamBatsmenVsBowlersAllOppnAllMatchesPlot}
\alias{teamBatsmenVsBowlersAllOppnAllMatchesPlot}
\title{Plot of Team batsmen vs bowlers against all opposition all matches}
\usage{
teamBatsmenVsBowlersAllOppnAllMatchesPlot(df,plot=TRUE)
}
\arguments{
\item{df}{The dataframe of all the matches of the team against all oppositions}

\item{plot}{If plot=TRUE the result is plotted or else the data frame is returned}
}
\value{
None or dataframe
}
\description{
This function computes the performance of batsmen against all bowlers of all oppositions in all matches.
The data frame can be either plotted or returned to the user
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get all matches for team India against all oppositions in all matches
matches <-getAllMatchesAllOpposition("India",dir="../data/",save=TRUE)

# Also load directly from file
#load("allMatchesAllOpposition-India.RData")

d <- teamBatsmanVsBowlersAllOppnAllMatchesRept(matches,"India",rank=1,dispRows=50)
teamBatsmenVsBowlersAllOppnAllMatchesPlot(d)
e <- teamBatsmenVsBowlersAllOppnAllMatchesPlot(d,plot=FALSE)
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData}
}
\seealso{
\code{\link{teamBatsmenVsBowlersAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenPartnershipOppnAllMatchesChart}}\cr
\code{\link{teamBatsmenPartnershipAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenVsBowlersOppnAllMatches}}\cr
}
\author{
Tinniam V Ganesh
}
