% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBatsmenVsBowlersOppnAllMatches.R
\name{teamBatsmenVsBowlersOppnAllMatches}
\alias{teamBatsmenVsBowlersOppnAllMatches}
\title{Team batsmen vs bowlers all matches of an opposition}
\usage{
teamBatsmenVsBowlersOppnAllMatches(matches,main,opposition,plot=1,top=5)
}
\arguments{
\item{matches}{All the matches of the team against one specific opposition}

\item{main}{The team for which the the batting partnerships are sought}

\item{opposition}{The opposition team}

\item{plot}{lot=1 (static),plot=2(interactive),plot=3(table)}

\item{top}{The number of players to be plotted or returned as a dataframe. The default is 5}
}
\value{
None or dataframe
}
\description{
This function computes the performance of batsmen against the  bowlers of an oppositions in all matches
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get all matches for team India against an opposition
matches <- getAllMatchesBetweenTeams("Australia","India",dir="../data")

# Get the performance of India batsman against Australia in all matches
teamBatsmenVsBowlersOppnAllMatches(a,"India","Australia")

# Display top 3
teamBatsmanVsBowlersOppnAllMatches(a,"Australia","India",top=3)

# Get top 10 and do not plot
n <- teamBatsmenVsBowlersOppnAllMatches(a,"Australia","India",top=10,plot=FALSE)
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{teamBatsmenVsBowlersAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenPartnershipOppnAllMatchesChart}}\cr
\code{\link{teamBatsmenPartnershipAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenVsBowlersOppnAllMatches}}\cr
}
\author{
Tinniam V Ganesh
}
