% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBowlersWicketKindOppnAllMatches.R
\name{teamBowlersWicketKindOppnAllMatches}
\alias{teamBowlersWicketKindOppnAllMatches}
\title{Team bowlers wicket kind against an opposition in all matches}
\usage{
teamBowlersWicketKindOppnAllMatches(matches,main,opposition,plot=TRUE)
}
\arguments{
\item{matches}{The data frame of all matches between a team the opposition. This dataframe can be obtained with
matches <- getAllMatchesBetweenTeams("Australia","India",dir="../data")}

\item{main}{The team for which the performance is required}

\item{opposition}{The opposing team}

\item{plot}{If plot=TRUE then a plot is displayed else a dataframe is returned}
}
\value{
None or dataframe
The return depends on the value of the plot
}
\description{
This function computes performance of bowlers of a team and the wicket kind against an
opposition in all matches against the opposition
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get all matches between India and Australia
matches <- getAllMatchesBetweenTeams("Australia","India",dir="../data")

teamBowlersWicketKindOppnAllMatches(matches,"India","Australia",plot=TRUE)
m <- teamBowlersWicketKindOppnAllMatches(matches,"Australia","India",plot=FALSE)

teamBowlersWicketKindOppnAllMatches(matches,"Australia","India",plot=TRUE)
}

}
\references{
\url{http://cricsheet.org/}\cr
\url{https://gigadom.wordpress.com/}\cr
\url{https://github.com/tvganesh/yorkrData}
}
\seealso{
\code{\link{teamBatsmenPartnershipAllOppnAllMatches}}
\code{\link{teamBatsmenPartnershipAllOppnAllMatchesPlot}}
\code{\link{teamBatsmenPartnershipOppnAllMatchesChart}}
\code{\link{teamBowlersVsBatsmenAllOppnAllMatchesRept}}
\code{\link{teamBowlersVsBatsmenAllOppnAllMatchesPlot}}
}
\author{
Tinniam V Ganesh
}
