% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustered-summary.R
\name{yotov_clustered_summary}
\alias{yotov_clustered_summary}
\title{Stata-Like Clustered Standard Errors Summary}
\usage{
yotov_clustered_summary(model, cluster)
}
\arguments{
\item{model}{Any \code{lm} or \code{glm} object}

\item{cluster}{The clustering variable in the model data (e.g.
\code{"pair_id"})}
}
\description{
Returns a list for a a general \code{lm} or \code{glm} which returns number
of observations, F-statistic (with degrees of freedom and p-value), R-squared
(and pseudo R-squared for poisson-type generalized models), root MSE and clustered
standard errors for estimated coefficients.
}
\examples{
# THESE REGRESSIONS ARE JUST FOR TESTING!!!

model1 <- lm(mpg ~ wt, data = mtcars)
yotov_clustered_summary(model1, "cyl")

model2 <- glm(mpg ~ wt, data = mtcars, family = quasipoisson)
yotov_clustered_summary(model2, "cyl")
}
