% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_plus_R.R
\name{L_plus_R}
\alias{L_plus_R}
\title{Runs the L_plus_R function}
\usage{
L_plus_R(pos, ws, X = NULL)
}
\arguments{
\item{pos}{A numeric vector of SNP locations}

\item{ws}{The window size which the \code{L_plus_R} statistic will be calculated over. This should be on the same scale as the \code{pos} vector.}

\item{X}{Optional. Specify a region of the chromosome to calculate \code{L_plus_R} for in the format \code{c(startposition, endposition)}. The start position and the end position should be within the extremes of the positions given in the \code{pos} vector. If not supplied, the function will calculate L_plus_R for every SNP in the \code{pos} vector.}
}
\value{
A list containing the SNP positions and the \code{L_plus_R }values for those SNPs
}
\description{
Returns the \eqn{{|L| \choose 2} + {|R| \choose 2}}{(|L| choose 2) + (|R| choose 2)} value for each SNP location supplied to the function. \code{|L|} and \code{|R|} are the number of SNPs to the left and right of the current locus within the given window \code{ws}.
For more information about the \code{L_plus_R} diversity statistic, please see Jacobs (2016).
}
\examples{
## load the snps example dataset
data(snps)
## run L_plus_R over all the SNPs with a window size of 3000 bp
L_plus_R(snps$positions,3000)
## only return results for SNPs between locations 600 and 1500 bp
L_plus_R(snps$positions,3000,X=c(600,1500))

}
\references{
Jacobs, G.S., T.J. Sluckin, and T. Kivisild, \emph{Refining the Use of Linkage Disequilibrium as a Robust Signature of Selective Sweeps.} Genetics, 2016. \strong{203}(4): p. 1807
}
