% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2dgrid.R
\name{qq_2d_grid}
\alias{qq_2d_grid}
\title{Quantile-quantile plot in 2d using the grid package}
\usage{
qq_2d_grid(
  zargs,
  do.line = TRUE,
  lines... = NULL,
  pch = NULL,
  size = 0.02,
  box = FALSE,
  box.width = 1,
  box.height = 1,
  group... = list(cex = 0.66),
  draw = FALSE,
  ...
)
}
\arguments{
\item{zargs}{argument list as passed from \code{\link{zenplot}()}}

\item{do.line}{logical indicating whether a line is drawn (through both
empirical c(0.25, 0.75)-quantiles)}

\item{lines...}{additional arguments passed to lines()}

\item{pch}{plot symbol}

\item{size}{size of the plot symbol}

\item{box}{logical indicating whether a box should be drawn}

\item{box.width}{width of the box}

\item{box.height}{height of the box}

\item{group...}{list of arguments passed to group_2d_grid (or NULL)}

\item{draw}{logical indicating whether drawing should take place}

\item{...}{additional arguments passed to gpar()}
}
\value{
grob (invisibly)
}
\description{
Quantile-quantile plot in 2d using the grid package
}
\note{
- line iff both margins are of the same *type*
      - The default point size was chosen to match the default of graphics
}
\seealso{
Other default 2d plot functions using the grid package: 
\code{\link{arrow_2d_grid}()},
\code{\link{axes_2d_grid}()},
\code{\link{density_2d_grid}()},
\code{\link{group_2d_grid}()},
\code{\link{label_2d_grid}()},
\code{\link{points_2d_grid}()},
\code{\link{rect_2d_grid}()}

Other default 2d plot functions: 
\code{\link{arrow_2d_graphics}()},
\code{\link{arrow_2d_grid}()},
\code{\link{arrow_2d_loon}()},
\code{\link{axes_2d_graphics}()},
\code{\link{axes_2d_grid}()},
\code{\link{axes_2d_loon}()},
\code{\link{density_2d_graphics}()},
\code{\link{density_2d_grid}()},
\code{\link{density_2d_loon}()},
\code{\link{extract_2d}()},
\code{\link{group_2d_graphics}()},
\code{\link{group_2d_grid}()},
\code{\link{group_2d_loon}()},
\code{\link{label_2d_graphics}()},
\code{\link{label_2d_grid}()},
\code{\link{label_2d_loon}()},
\code{\link{points_2d_graphics}()},
\code{\link{points_2d_grid}()},
\code{\link{points_2d_loon}()},
\code{\link{qq_2d_graphics}()},
\code{\link{rect_2d_graphics}()},
\code{\link{rect_2d_grid}()},
\code{\link{rect_2d_loon}()}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{default 2d plot functions}
\concept{default 2d plot functions using the grid package}
