% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{extract_2d}
\alias{extract_2d}
\title{Extracting information for our default/provided plot2d()}
\usage{
extract_2d(zargs)
}
\arguments{
\item{zargs}{The argument list  as passed from \code{\link{zenplot}()}.
This must at least contain \code{x}, \code{vars}, \code{num}, \code{lim} and
\code{labs} (for \code{extract_2d()});  see \code{\link{zenplot}()}
for an explanation of these variables.}
}
\value{
A list \code{\link{list}} with
    \describe{
       \item{\code{x} and \code{y}:}{the data to be plotted in the 2d plot}
       \item{\code{xcols}:}{a list with all columns of \code{x}}
       \item{\code{groups}:}{the group numbers for each column of \code{x}}
       \item{\code{vars}:}{the variable numbers for each column of \code{x}}
       \item{\code{glabs}:}{the group labels for each column of \code{x}}
       \item{\code{vlabs}:}{the variable labels for each column of \code{x}}
       \item{\code{xlim} and \code{ylim}:}{the x-axis and y-axis limits, and}
       \item{\code{same.group}:}{a \code{\link{logical}} indicating
       whether the x and y variables belong to the same group.}
       }
}
\description{
Extracting information for our default/provided plot2d()
}
\details{
This is an auxiliary function called on \code{zargs} within any
         1d plotting function (e.g. \code{\link{hist_1d_grid}},
         \code{\link{density_1d_graphics}}, or \code{\link{points_1d_loon}})
         to extract the 1d data from \code{zargs} needed for plotting.
         For performance reasons, no checking of the input object is done.
}
\note{
Performance critical
}
\examples{
## This function is used within the default (any user defined)
## 2d plot functions
##
my_2d_plot <- function(zargs, your_name = "BillyBob", ...) {
                   data_2d <- extract_2d(zargs)
                   msg <- paste("Components of zargs available",
                                "to construct a 2d plot for ",
                                your_name)
                   print(msg)
                   ## just print the names of the data components
                   ## which you might want to use in your plot
                   print(names(data_2d))

                   ## You can plot whatever you want using the information in
                   ## could use any of these to construct any 1d plot you want
                   ## using R's graphics or any of zemplot's built in 1d plots.
                   ##
                   ## For example, here we could use
                   ## use zenplot's base graphics functions
                   ## First a scatterplot
                   points_2d_graphics(zargs, ...)
                   ## to which we overlay density contours
                   density_2d_graphics(zargs, add = TRUE, col = "steelblue", ...)
                   ## similar functions could be called for the other packages.
                   ## You can print the source of anyone of the default functions
                   ## to get some idea of managing details.
                }

## And now try it out
zenplot(iris, plot2d = my_2d_plot)
}
\seealso{
Other tools for constructing your own plot1d and plot2d functions: 
\code{\link{burst_aux}()},
\code{\link{burst}()},
\code{\link{check_zargs}()},
\code{\link{extract_1d}()},
\code{\link{plot_indices}()}

Other data extraction functions to build plots: 
\code{\link{extract_1d}()}

Other default 2d plot functions: 
\code{\link{arrow_2d_graphics}()},
\code{\link{arrow_2d_grid}()},
\code{\link{arrow_2d_loon}()},
\code{\link{axes_2d_graphics}()},
\code{\link{axes_2d_grid}()},
\code{\link{axes_2d_loon}()},
\code{\link{density_2d_graphics}()},
\code{\link{density_2d_grid}()},
\code{\link{density_2d_loon}()},
\code{\link{group_2d_graphics}()},
\code{\link{group_2d_grid}()},
\code{\link{group_2d_loon}()},
\code{\link{label_2d_graphics}()},
\code{\link{label_2d_grid}()},
\code{\link{label_2d_loon}()},
\code{\link{points_2d_graphics}()},
\code{\link{points_2d_grid}()},
\code{\link{points_2d_loon}()},
\code{\link{qq_2d_graphics}()},
\code{\link{qq_2d_grid}()},
\code{\link{rect_2d_graphics}()},
\code{\link{rect_2d_grid}()},
\code{\link{rect_2d_loon}()}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{data extraction functions to build plots}
\concept{default 2d plot functions}
\concept{tools for constructing your own plot1d and plot2d functions}
