% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zerotradeflow.R
\name{get_zerotradeflow}
\alias{get_zerotradeflow}
\title{Expand the dataset from the passed database as parameters.}
\usage{
get_zerotradeflow(data, year, exporter, importer, item, trade)
}
\arguments{
\item{data}{a data set containing the variables that will be used to guide
the expansion of the base including all possible combinations of the reference
variables.}

\item{year}{refers to the column in the database that contains information for
the years under review.}

\item{exporter}{refers to the column with the ISO codes (ISO 3166 standard -
Codes for the representation of names of countries and their subdivisions,
created and maintains by International Organization for Standardization - ISO)
of each exporter country (Ex.: BRA, PRT, ITA, USA,...).}

\item{importer}{refers to the column with the ISO codes (ISO 3166 standard -
Codes for the representation of names of countries and their subdivisions,
created and maintains by International Organization for Standardization - ISO)
of each importer country (Ex.: BRA, PRT, ITA, USA,...).}

\item{item}{refers to the column in the database that contains information
about Harmonized System (HS) codes, or other classification. Harmonized
System is an acronym for Harmonized Commodity Designation and Coding System,
and it is a customs nomenclature, used internationally as a standardized
system of coding and classification of import and export products, developed
and maintained by the World Customs Organization (WCO).}

\item{trade}{refers to the column in the database that contains information
about the value of exports/imports}
}
\value{
a dataframe object contains the five variables passed as parameters
to the get_zerotradeflow() function (year, exporter, importer, item, trade)
including the bilateral trade flow equal to zero.
}
\description{
Creates zero bilateral trade flow for a given pair of countries.
}
\details{
The zerotradeflow package allows generating the bilateral trade flow equal
to zero of each country pair in each year present in the database passed in
data parameter. Since, by default, data on bilateral trade flows of countries
only report positive trade flows (flows greater than zero).

Function to expand the database with the bilateral trade flow equal
to zero, passing the following parameters:
}
