% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/functions_package.R
\name{Zeta.varpart}
\alias{Zeta.varpart}
\title{Variation partitioning for zeta diversity}
\usage{
Zeta.varpart(xy, data.spec, data.env, order = 2, sam = 1000,
  method = "mean", standard = TRUE)
}
\arguments{
\item{xy}{Site coordinates}

\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{data.env}{Sites-by-variable data frame, with sites as rows and environmental variables as columns.}

\item{order}{Specific number of assemblages or sites at which zeta diversity is computed.}

\item{sam}{Number of samples for which the zeta-diversity is computed.}

\item{method}{Indicates which distance to consider for more than 3 sites. Method can be "\code{mean}" or "\code{max}"}

\item{standard}{Boolean parameter indicating if the spatial distances and differences in environmental variables should be standardized between 0 and 1.}
}
\value{
\code{Zeta.varpart} returns a list containing the following components:

\item{varpart}{Object of class "\code{varpart}", containing the output of the variation partitioning of zeta over the distance and environmental variables.}

\item{signif.abc}{Object of class "\code{anova}", showing the significance of the partitioning of zeta over all variables.}

\item{signif.ab}{Object of class "\code{anova}", showing the significance of the partitioning of zeta over distance.}

\item{signif.bc}{Object of class "\code{anova}", showing the significance of the partitioning of zeta over the environmental variables.}

\item{signif.a}{Object of class "\code{anova}", showing the significance of the partitioning of zeta over distance, removing the part relative to the environmental variables.}

\item{signif.c}{Object of class "\code{anova}", showing the significance of the partitioning of zeta over the environmental variables, removing the part relative to distance.}
}
\description{
Variation partitioning of zeta diversity for a specific order (number of assemblages or sites) over distance and environmental variables.
}
\details{
This function calls function \code{varpart} from package \{vegan\} and apply it to zeta for a specific order (number of assemblages or sites). The variation partitioning is based on adjusted R squared to account for the differences in numbers of explanatory variables.
}
\examples{
data(BCI.spec.coarse)
xy <- BCI.spec.coarse[1:2]
data.spec <- BCI.spec.coarse[3:308]
data(BCI.env.coarse)
data.env <- BCI.env.coarse[10:15]

zeta.varpart <- Zeta.varpart(xy, data.spec, data.env, order = 3, sam = 100)
zeta.varpart
dev.new()
plot(zeta.varpart$varpart)
dev.new()
pie.neg(zeta.varpart$varpart$part$indfract[, 3], density = c(4, 0, 8, -1),
    angle = c(90, 0, 0, 0), labels = c("distance", "b", "environment", "d"), radius = 0.9)

##########

data(Marion.species)
xy <- Marion.species[1:2]
data.species <- Marion.species[3:33]
data(Marion.env)
data.env <- Marion.env[3:4]

zeta.varpart.species <- Zeta.varpart(xy, data.species, data.env, order = 3, sam = 100)
zeta.varpart.species
dev.new()
plot(zeta.varpart.species$varpart)
dev.new()
pie.neg(zeta.varpart.species$varpart$part$indfract[, 3], density = c(4, 0, 8, -1),
    angle = c(90, 0, 0, 0), labels = c("distance", "b", "environment", "d"), radius = 0.9)
}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.

Borcard, D., Legendre, P. & Drapeau, P. (1992). Partialling out the spatial component of ecological variation. \emph{Ecology} 73, 1045-1055.

Legendre, P. &  Legendre, L.F. (2012). \emph{Numerical ecology}, 3rd English edition. Elsevier Science BV, Amsterdam.
}
\seealso{
\code{\link{Zeta.decline}}, \code{\link{Zeta.order}}, \code{\link{Zeta.lm}}, \code{\link{Zeta.gam}}
}

