% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{unzip_process}
\alias{unzip_process}
\title{Class for an external unzip process}
\usage{
unzip_process()
}
\value{
An \code{unzip_process} R6 class object, a subclass of
\link[processx:process]{processx::process}.
}
\description{
\code{unzip_process()} returns an R6 class that represents an unzip process.
It is implemented as a subclass of \link[processx:process]{processx::process}.
}
\section{Using the \code{unzip_process} class}{
\preformatted{up <- unzip_process()$new(zipfile, exdir = ".")
}

See \link[processx:process]{processx::process} for the class methods.

Arguments:
\itemize{
\item \code{zipfile}: Path to the zip file to uncompress.
\item \code{exdir}: Directory to uncompress the archive to. If it does not
exist, it will be created.
}
}

\examples{
ex <- system.file("example.zip", package = "zip")
tmp <- tempfile()
up <- unzip_process()$new(ex, exdir = tmp)
up$wait()
up$get_exit_status()
dir(tmp)
}
