% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmviterbi2.cont.R
\name{hmmviterbi2.cont}
\alias{hmmviterbi2.cont}
\title{Viterbi algorithm to decode the latent states in continuous-time
hidden Markov models with covariates}
\usage{
hmmviterbi2.cont(y, M, workparm, zero_init, emit_x = NULL,
  zeroinfl_x = NULL, timeindex, plot = FALSE, xlim = NULL, ylim = NULL,
  ...)
}
\arguments{
\item{y}{the observed series to be decoded}

\item{M}{number of latent states}

\item{workparm}{a vector of values for working parameters, which is the last element returned 
from hmmfit() function. This consists the generalized logit of prior probabilities 
(except for the 1st state), generalized logit of transition probability matrix
(except for the 1st column), the  logit of nonzero structural zero proportions, and 
the log poisson means}

\item{zero_init}{a vector containing structural zero proportions in each state, e.g. set
zero_init[i] to be 0 if the i-th state is a regular poisson, and otherwise 1.}

\item{emit_x}{matrix of covariates for the log poisson means. Default to NULL.}

\item{zeroinfl_x}{matrix of covariates for the nonzero structural zero proportions. Default to NULL.}

\item{timeindex}{a vector containing the time points}

\item{plot}{whether a plot should be returned}

\item{xlim}{vector specifying the minimum and maximum on the x-axis in the plot. 
Default to NULL.}

\item{ylim}{vector specifying the minimum and maximum on the y-axis in the plot. 
Default to NULL.}

\item{...}{further arguments to be passed to the plot() function}
}
\value{
decoded series of latent states
}
\description{
Viterbi algorithm to decode the latent states in continuous-time
hidden Markov models with covariates
}
\examples{
priorparm <- 0
tpmparm <- c(-1,-2)
zeroindex <- c(1,0)
zeroparm <- c(0,-1,1)
emitparm <- c(2,0.5,-0.5,3,0.3,-0.2)
workparm <- c(priorparm,tpmparm,zeroparm,emitparm)
timeindex <- rep(1,1000)
for(i in 2:1000) timeindex[i] <- timeindex[i-1] + sample(1:4,1)

designx <- matrix(rnorm(2000),nrow=1000,ncol=2)
x <- cbind(1,designx) #has to make the additional 1st column of 1 for intercept
result <- hmmsim2.cont(workparm,2,1000,zeroindex,emit_x=designx,
                      zeroinfl_x=designx,timeindex=timeindex)
y <- result$series
state <- result$state

fit2 <-  fasthmmfit.cont(y=y,x=designx,M=2,prior_init=c(0.5,0.5),
  tpm_init=matrix(c(-0.2,0.2,0.1,-0.1),2,2,byrow=TRUE),
  zero_init=0.4,emit_init=c(7,21), timeindex=timeindex,
  hessian=FALSE, method="BFGS", control=list(trace=1))
decode2 <- hmmviterbi2.cont(y,2,fit2$working_parm,c(1,0),
  emit_x=designx, zeroinfl_x=designx,
  timeindex=timeindex,plot=FALSE)
}
\references{
Walter Zucchini, Iain L. MacDonald, Roland Langrock. Hidden Markov Models for 
Time Series: An Introduction Using R, Second Edition. Chapman & Hall/CRC
}
