% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_get_geometry.R
\name{zi_get_geometry}
\alias{zi_get_geometry}
\title{Download and Optionally Geoprocess ZCTAs}
\usage{
zi_get_geometry (year, style = "zcta5", return = "id", class = "sf",
    state = NULL, county = NULL, territory = NULL, cb = FALSE,
    starts_with = NULL, includes = NULL, excludes = NULL, method,
    shift_geo = FALSE)
}
\arguments{
\item{year}{A four-digit numeric scalar for year. \code{zippeR} currently
supports data between 2010 and 2023}

\item{style}{A character scalar - either \code{"zcta5"} or \code{"zcta3"}.
See Details below.}

\item{return}{A character scalar; if \code{"id"} (default), only the five-digit
number of each ZCTA (or three-digit if \code{style = "zcta3"}) is returned.
This is the only valid option for  \code{style = "zcta3"}. For
\code{style = "zcta5"}, if \code{return = "full"}, all TIGER/Line columns
are returned.}

\item{class}{A character scalar; if \code{"sf"} (default), a \code{sf} object
suitable for mapping will be returned. If \code{"tibble"}, an object
that omits the geometric data will be returned instead.}

\item{state}{A character scalar or vector with character state abbreviations
(e.x. \code{"MO"}) or numeric FIPS codes (e.x. \code{29}). ZCTAs that
are within the given states (determined based on a combination of
\code{year} and \code{method}) will be returned. See Details below for
more information. This argument is optional unless a argument is also
specified for \code{county}.}

\item{county}{A character scalar or vector with character GEOIDs (e.x.
\code{"29510"}). ZCTAs that are within the given states (determined based
on a combination of \code{year} and \code{method}) will be returned. See
Details below for more information. This argument is optional.}

\item{territory}{A character scalar or vector with character territory abbreviations
(e.x. \code{"PR"}) or numeric FIPS codes (e.x. \code{72}). ZCTAs that are
within the given territories will be returned. By default, all territories
are excluded. The five territory abbreviations are: \code{"AS"} (American
Samoa), \code{"GU"} (Guam), \code{"MP"} (Northern Mariana Islands),
\code{"PR"} (Puerto Rico), and \code{"VI"} (U.S. Virgin Islands).}

\item{cb}{A logical scalar; if \code{FALSE}, the most detailed TIGER/Line
    data will be used for \code{style = "zcta5"}. If \code{TRUE}, a
    generalized (1:500k) version of the data will be used. The generalized
    data will download significantly faster, though they show less detail.
    According to the \code{tigris::zctas()} documentation, the download size
    if \code{TRUE} is ~65MB while it is ~500MB if \code{cb = FALSE}.

    This argument does not apply to \code{style = "zcta3"}, which only returns
    generalized data. It also does not apply if \code{class = "tibble"}.}

\item{starts_with}{A character scalar or vector containing the first two
digits of a GEOID or ZCTA3 value to return. It defaults to \code{NULL},
which will return all ZCTAs in the US. For example, supplying the argument
\code{starts_with = c("63", "64")} will return only those ZCTAs or ZCTA3s
that begin with 63 or 64. If you supply a state or a county, that will limit
the data this argument is applied to, potentially leading to missed ZCTAs.}

\item{includes}{A character scalar or vector containing GEOID's or ZCTA3 values
to include when finalizing output. This may be necessary depending on what
is identified with the \code{method} argument.}

\item{excludes}{A character scalar or vector containing GEOID's or ZCTA3 values
to exclude when finalizing output. This may be necessary depending on what
is identified with the \code{method} argument.}

\item{method}{A character scalar - either \code{"intersect"} or \code{"centroid"}.
See Details below.}

\item{shift_geo}{A logical scalar; if \code{TRUE}, Alaska, Hawaii, and Puerto Rico
will be re-positioned so that the lie to the southwest of the continental
United States. This defaults to \code{FALSE}, and can only be used when
states are not listed for the \code{state} argument. It does not apply
if \code{class = "tibble"}.}
}
\value{
A \code{sf} object with ZCTAs matching the parameters specified above:
    either a nationwide file, a specific state or states, or a specific
    county or counties.
}
\description{
This function returns geometric data for ZIP Code Tabulation
    Areas (ZCTAs), which are rough approximations of many (but not all)
    USPS ZIP codes. Downloading and processing these data will be heavily
    affected by your internet connection, your choice for the \code{cb}
    argument, and the processing power of your computer (if you select
    specific counties).
}
\details{
This function contains options for both the type of ZCTA and,
    optionally, for how state and county data are identified. For type,
    either five-digit or three-digit ZCTA geometries are available. The
    three-digit ZCTAs were created by geoprocessing the five-digit boundaries
    for each year, and then applying a modest amount of simplification
    (with \code{sf::st_simplify()}) to reduce file size. The source files
    are available on GitHub at \url{https://github.com/chris-prener/zcta3}.

    Since ZCTAs cross state lines, two methods are used to create these
    geometry data for years 2012 and beyond for states and all years for counties.
    The \code{"intersect"} method  will return ZCTAs that border the states or
    counties selected. In most  cases, this will result in more ZCTAs being
    returned than are actually within the states or counties selected.
    Conversely, the \code{"centroid"} method will return only ZCTAs whose
    centroids (geographical centers) lie within the states or counties named.
    In most cases, this will return fewer ZCTAs than actually lie within the
    states or counties selected. Users will need to review their data carefully
    and will likely need to use the \code{include} and \code{exclude} arguments
    to finalize the geographies returned.

    For state-level data in 2010 and 2011, the Census Bureau published individual
    state files that will be utilized automatically by \code{zippeR}. If
    county-level data are requested for these years, the state-specific file
    will be used as a base before identifying ZCTAs within counties using
    either the \code{"intersect"} or \code{"centroid"} method described above.
}
\examples{
\donttest{
  # five-digit ZCTAs
  ## download all ZCTAs for 2020 including territories
  zi_get_geometry(year = 2020, territory = c("AS", "GU", "MP", "PR", "VI"),
      shift_geo = TRUE)

  ## download all ZCTAs for 2020 excluding territories
  zi_get_geometry(year = 2020, shift_geo = TRUE)

  ## download all ZCTAs in a selection of states, intersects method
  zi_get_geometry(year = 2020, state = c("IA", "IL", "MO"), method = "intersect")

  ## download all ZCTAs in a single county - St. Louis City, MO
  zi_get_geometry(year = 2020, state = "MO", county = "29510",
      method = "intersect")

  # three-digit ZCTAs
  ## download all ZCTAs for 2018 including territories
  zi_get_geometry(year = 2018, territory = c("AS", "GU", "MP", "PR", "VI"),
      shift_geo = TRUE)
}

}
