% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{lookuper}
\alias{lookuper}
\title{Construct lookup function based on a specific lookup table}
\usage{
lookuper(lookup_table)
}
\arguments{
\item{lookup_table}{A the lookup table that should be used as the underlying
lookup table for the returned function.}
}
\value{
A function that takes \code{character} vectors as its argument \code{x}, and
returns either the corresponding values from the underlying lookup table,
or the original values from x for those elements that are not found in the
lookup table.
}
\description{
The \code{\link[=lookuper]{lookuper()}} function returns \emph{a function} equivalent to the \code{\link[=lookup]{lookup()}}
function, except that instead of taking a lookup table as an argument, the
lookup table is embedded in the function itself.

This can be very useful, in particular when using the lookup function as an
argument to other functions that expect a function which maps
\code{character}->\code{character} but do not offer a good way to pass additional
arguments to that function.
}
\examples{
lookup_fruits <- lookuper(list(a="Apple", b="Banana", c="Cherry"))
lookup_fruits(letters[1:5])

}
