% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThesaurusReaderWriter.R
\name{ThesaurusReaderWriter}
\alias{ThesaurusReaderWriter}
\alias{ReadThesaurus}
\alias{ReadThesaurusSet}
\alias{WriteThesaurus}
\alias{WriteThesaurusSet}
\title{Thesaurus Readers and Writers}
\usage{
ReadThesaurus(
  file,
  caseSensitive = FALSE,
  accentSensitive = FALSE,
  punctuationSensitive = FALSE
)

ReadThesaurusSet(file)

WriteThesaurus(thesaurus, file)

WriteThesaurusSet(thesaurusSet, file)
}
\arguments{
\item{file}{Name of a file.}

\item{caseSensitive, accentSensitive, punctuationSensitive}{Logical. They set
the case, accent, and punctuation sensitivity (\code{FALSE} by default) of
the thesaurus.}

\item{thesaurus}{A thesaurus object.}

\item{thesaurusSet}{A thesaurus set.}
}
\value{
\code{WriteThesaurus} and \code{WriteThesaurusSet} create or overwrite the
corresponding files. No value is returned.

\code{ReadThesaurus} and \code{ReadThesaurusSet} return the read thesaurus or
thesaurusSet, respectively.
}
\description{
Functions to read and write thesauri and thesaurus sets.
}
\examples{
## Read a thesaurus for taxa:
thesaurusFile <- system.file("extdata", "taxonThesaurus.csv", package="zoolog")
thesaurus <- ReadThesaurus(thesaurusFile)
## The attributes of the thesaurus include the fields 'caseSensitive',
## 'accentSensitive', and 'punctuationSensitive', all FALSE by default.
attributes(thesaurus)

## Any of them can be set by the user if desired:
thesaurus2 <- ReadThesaurus(thesaurusFile, accentSensitive = TRUE)
attributes(thesaurus2)

## Write the thesarus to a file:
fileExample <- file.path(tempdir(), "thesaurusExample.csv")
WriteThesaurus(thesaurus, fileExample)
## Replace tempdir() for your preferred local path if you want to easily
## examine the written file.

## Read a thesaurus set:
thesaurusSetFile <- system.file("extdata", "zoologThesaurusSet.csv", package="zoolog")
thesaurusSet <- ReadThesaurusSet(thesaurusSetFile)
## The attributes of the thesaurus set include information of the constituent
## thesauri: names, source file names, and their mode of application on datasets.
attributes(thesaurusSet)
## The attributes of each thesaurus are also set by 'ReadThesaurusSet'.
attributes(thesaurusSet$measure)

## Write the thesaurus set to a file:
fileSetExample <- file.path(tempdir(), "thesaurusSetExample.csv")
WriteThesaurusSet(thesaurusSet, fileSetExample)
## It writes the thesaurus-set main data frame and each of the included
## thesaurus files.
## Again, replace tempdir() for your preferred local path if you want to
## easily examine the written files.

}
\seealso{
\code{\link{zoologThesaurus}} for a description of the thesaurus and
thesaurus set structure,

\code{\link{ThesaurusManagement}},
\code{\link{StandardizeNomenclature}}
}
