

































































#[cfg_attr(doc_cfg, doc(cfg(all(feature = "parsing", feature = "printing"))))]
#[macro_export]
macro_rules! parse_quote {
    ($($tt:tt)*) => {
        $crate::__private::parse_quote($crate::__private::quote::quote!($($tt)*))
    };
}

























#[cfg_attr(doc_cfg, doc(cfg(all(feature = "parsing", feature = "printing"))))]
#[macro_export]
macro_rules! parse_quote_spanned {
    ($span:expr=> $($tt:tt)*) => {
        $crate::__private::parse_quote($crate::__private::quote::quote_spanned!($span=> $($tt)*))
    };
}




use crate::parse::{Parse, ParseStream, Parser, Result};
use proc_macro2::TokenStream;


#[doc(hidden)]
pub fn parse<T: ParseQuote>(token_stream: TokenStream) -> T {
    let parser = T::parse;
    match parser.parse2(token_stream) {
        Ok(t) => t,
        Err(err) => panic!("{}", err),
    }
}

#[doc(hidden)]
pub trait ParseQuote: Sized {
    fn parse(input: ParseStream) -> Result<Self>;
}

impl<T: Parse> ParseQuote for T {
    fn parse(input: ParseStream) -> Result<Self> {
        <T as Parse>::parse(input)
    }
}




use crate::punctuated::Punctuated;
#[cfg(any(feature = "full", feature = "derive"))]
use crate::{attr, Attribute, Field, FieldMutability, Ident, Type, Visibility};
#[cfg(feature = "full")]
use crate::{Block, Pat, Stmt};

#[cfg(any(feature = "full", feature = "derive"))]
impl ParseQuote for Attribute {
    fn parse(input: ParseStream) -> Result<Self> {
        if input.peek(Token![#]) && input.peek2(Token![!]) {
            attr::parsing::single_parse_inner(input)
        } else {
            attr::parsing::single_parse_outer(input)
        }
    }
}

#[cfg(any(feature = "full", feature = "derive"))]
impl ParseQuote for Field {
    fn parse(input: ParseStream) -> Result<Self> {
        let attrs = input.call(Attribute::parse_outer)?;
        let vis: Visibility = input.parse()?;

        let ident: Option<Ident>;
        let colon_token: Option<Token![:]>;
        let is_named = input.peek(Ident) && input.peek2(Token![:]) && !input.peek2(Token![::]);
        if is_named {
            ident = Some(input.parse()?);
            colon_token = Some(input.parse()?);
        } else {
            ident = None;
            colon_token = None;
        }

        let ty: Type = input.parse()?;

        Ok(Field {
            attrs,
            vis,
            mutability: FieldMutability::None,
            ident,
            colon_token,
            ty,
        })
    }
}

#[cfg(feature = "full")]
impl ParseQuote for Pat {
    fn parse(input: ParseStream) -> Result<Self> {
        Pat::parse_multi_with_leading_vert(input)
    }
}

#[cfg(feature = "full")]
impl ParseQuote for Box<Pat> {
    fn parse(input: ParseStream) -> Result<Self> {
        <Pat as ParseQuote>::parse(input).map(Box::new)
    }
}

impl<T: Parse, P: Parse> ParseQuote for Punctuated<T, P> {
    fn parse(input: ParseStream) -> Result<Self> {
        Self::parse_terminated(input)
    }
}

#[cfg(feature = "full")]
impl ParseQuote for Vec<Stmt> {
    fn parse(input: ParseStream) -> Result<Self> {
        Block::parse_within(input)
    }
}
