use super::*;


#[derive(PartialEq, Clone)]
pub struct Promise {
    pub(crate) robj: Robj,
}

impl Promise {










    #[cfg(feature = "non-api")]
    pub fn from_parts(code: Robj, environment: Environment) -> Result<Self> {
        single_threaded(|| unsafe {
            let sexp = Rf_allocSExp(SEXPTYPE::PROMSXP);
            let robj = Robj::from_sexp(sexp);
            SET_PRCODE(sexp, code.get());
            SET_PRENV(sexp, environment.robj.get());
            SET_PRVALUE(sexp, R_UnboundValue);
            Ok(Promise { robj })
        })
    }

    #[cfg(feature = "non-api")]

    pub fn code(&self) -> Robj {
        unsafe {
            let sexp = self.robj.get();
            Robj::from_sexp(PRCODE(sexp))
        }
    }

    #[cfg(feature = "non-api")]

    pub fn environment(&self) -> Environment {
        unsafe {
            let sexp = self.robj.get();
            Robj::from_sexp(PRENV(sexp)).try_into().unwrap()
        }
    }

    #[cfg(feature = "non-api")]

    pub fn value(&self) -> Robj {
        unsafe {
            let sexp = self.robj.get();
            Robj::from_sexp(PRVALUE(sexp))
        }
    }

    #[cfg(feature = "non-api")]

    pub fn seen(&self) -> i32 {
        unsafe {
            let sexp = self.robj.get();
            PRSEEN(sexp)
        }
    }

    #[cfg(feature = "non-api")]









    pub fn eval(&self) -> Result<Robj> {
        assert!(self.is_promise());
        if !self.value().is_unbound_value() {
            Ok(self.value())
        } else {
            self.robj.eval()
        }
    }
}

impl std::fmt::Debug for Promise {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut result = f.debug_struct("Promise");

        #[cfg(feature = "non-api")]
        {
            let result = result.field("code", &self.code());
            let result = result.field("environment", &self.environment());
        }
        result.finish()
    }
}
