




























































#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(improper_ctypes)]

include!(concat!(env!("OUT_DIR"), "/bindings.rs"));

#[non_exhaustive]
#[repr(transparent)]
#[derive(Debug)]
pub struct SEXPREC(std::ffi::c_void);

extern "C" {

    pub fn TYPEOF(x: SEXP) -> SEXPTYPE;
}

#[allow(non_camel_case_types)]
pub type R_altrep_Coerce_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXPTYPE) -> SEXP>;

pub unsafe fn Rf_isS4(arg1: SEXP) -> Rboolean {
    unsafe {
        if secret::Rf_isS4_original(arg1) == 0 {
            Rboolean::FALSE
        } else {
            Rboolean::TRUE
        }
    }
}

mod secret {
    use super::*;
    extern "C" {
        #[link_name = "Rf_isS4"]
        pub fn Rf_isS4_original(arg1: SEXP) -> u32;
    }
}

impl From<Rboolean> for bool {
    fn from(value: Rboolean) -> Self {
        match value {
            Rboolean::FALSE => false,
            Rboolean::TRUE => true,
        }
    }
}

impl From<bool> for Rboolean {
    fn from(value: bool) -> Self {
        match value {
            true => Rboolean::TRUE,
            false => Rboolean::FALSE,
        }
    }
}

#[cfg(test)]
mod tests {
    use super::*;
    use std::os::raw;




    macro_rules! cstr {
        ($s: expr) => {
            concat!($s, "\0").as_ptr() as *const raw::c_char
        };
    }




    macro_rules! cstr_mut {
        ($s: expr) => {
            concat!($s, "\0").as_ptr() as *mut raw::c_char
        };
    }


    fn start_R() {
        unsafe {
            if std::env::var("R_HOME").is_err() {

                std::env::set_var("R_HOME", env!("R_HOME"));
            }






            if cfg!(target_os = "windows") && cfg!(target_arch = "x86") {
                Rf_initialize_R(
                    4,
                    [
                        cstr_mut!("R"),
                        cstr_mut!("--arch=i386"),
                        cstr_mut!("--slave"),
                        cstr_mut!("--no-save"),
                    ]
                    .as_mut_ptr(),
                );
            } else {
                Rf_initialize_R(
                    3,
                    [cstr_mut!("R"), cstr_mut!("--slave"), cstr_mut!("--no-save")].as_mut_ptr(),
                );
            }





            if cfg!(not(target_os = "windows")) {
                R_CStackLimit = usize::max_value();
            }

            setup_Rmainloop();
        }
    }


    #[test]
    fn test_eval() {
        start_R();
        unsafe {
            let val = Rf_protect(R_ParseEvalString(cstr!("1"), R_NilValue));
            Rf_PrintValue(val);
            assert_eq!(TYPEOF(val), SEXPTYPE::REALSXP);
            assert_eq!(*REAL(val), 1.);
            Rf_unprotect(1);
        }


        unsafe {
            let sexp = R_ParseEvalString(cstr!(r#"new("factor")"#), R_GlobalEnv);
            Rf_protect(sexp);
            Rf_PrintValue(sexp);

            assert_eq!(
                std::mem::discriminant(&Rf_isS4(sexp)),
                std::mem::discriminant(&Rboolean::TRUE),
            );
            assert!(<Rboolean as Into<bool>>::into(Rf_isS4(sexp)));
            assert!(
                (Rboolean::FALSE == Rf_isS4(sexp)) || (Rboolean::TRUE == Rf_isS4(sexp)),
                "PartialEq implementation is broken"
            );
            assert!(Rboolean::TRUE == Rf_isS4(sexp));
            assert_eq!(Rf_isS4(sexp), Rboolean::TRUE);
            Rf_unprotect(1);
        }
    }
}
