% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_registration_questions.R
\name{get_registration_questions}
\alias{get_registration_questions}
\title{Get Webinar Registration Question Responses}
\usage{
get_registration_questions(
  webinar_id,
  account_id,
  client_id,
  client_secret,
  registrant_status = c("approved")
)
}
\arguments{
\item{webinar_id}{Zoom Webinar Id, typically an 11 digit number.}

\item{account_id}{Account Id granted by the Zoom developer app.}

\item{client_id}{Client Id granted by the Zoom developer app.}

\item{client_secret}{Client secret granted by the Zoom developer app.}

\item{registrant_status}{One or more of "approved", "pending", or
"denied". Default is "approved" only.}
}
\value{
A data frame with the registration question answers.
}
\description{
Get registration question answers from all registrants for a single webinar.
}
\examples{
\dontrun{
dat <- get_registration_questions(webinar_id = "99911112222",
  your_account_id,
  your_client_id,
  your_client_secret,
  c("approved", "denied", "pending"))
}
}
\seealso{
See <https://marketplace.zoom.us/docs/api-reference/zoom-api/> for 
documentation on the Zoom API.
}
