% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zscorer.R
\docType{data}
\name{wgsData}
\alias{wgsData}
\title{wgsData}
\format{A data frame with 6 columns and 1746 rows.
\describe{
\item{\code{indicator}}{One of weight-for-age (\code{waz}),
    height-for-age (\code{haz}), or weight-for-height (\code{whz})
    anthropometric indicators}
\item{\code{sex}}{Sex of child (1 = Male; 2 = Female)}
\item{\code{given}}{Variable to which standardisation is to be made. For
    \code{waz} and \code{haz}, \code{given} is age in months. For \code{whz},
    \code{given} is height in cm}
\item{\code{l}}{\code{L} component of the LMS method for normalising growth
    centile standards. \code{L} is the trend in the optimal power to obtain
    normality}
\item{\code{m}}{\code{M} component of the LMS method for normalising growth
    centile standards. \code{M} is the trend in the mean}
\item{\code{s}}{\code{S} component of the LMS method for normalising growth
    centile standards. \code{S} is the trend in the coefficient of variation}
}}
\source{
\cite{World Health Organization. WHO Child Growth Standards:
Length/Height-for-age, Weight-for-age, Weight-for-length, Weight-for-height,
and Body Mass Index-for age: Methods and Development. 1st ed.
World Health Organization; 2006.}
}
\usage{
wgsData
}
\description{
World Health Organization (WHO) Growth Reference (2006) data
}
\keyword{datasets}
