% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_func.R
\name{compute_NB_DIC}
\alias{compute_NB_DIC}
\title{DIC for BSTNB or BNB fitted objects}
\usage{
compute_NB_DIC(y,bstfit)
}
\arguments{
\item{y}{vector of counts, must be non-negative, the response used for fitting a BSTNB or BSTP model}

\item{bstfit}{BSTNB or BNB fitted object}
}
\value{
DIC value
}
\description{
Computes DIC for a BSTNB or BNB fitted object
}
\examples{
data(simdat)
y <- simdat$y
X <- cbind(simdat$V1,simdat$x)
data(county.adjacency)
data(USAcities)
IAcities <- subset(USAcities,state_id=="IA")
countyname <- unique(IAcities$county_name)
A <- get_adj_mat(county.adjacency,countyname,c("IA"))
\donttest{
res2 <- BSTNB(y, X, A, nchain=3, niter=100, nburn=20, nthin=1)
compute_NB_DIC(y,res2)
}

}
