% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SC_ordered.R
\name{SC_Ordered}
\alias{SC_Ordered}
\title{Create Stratigraphically Ordered Sample Matrix}
\usage{
SC_Ordered(Nb_sample)
}
\arguments{
\item{Nb_sample}{\link{integer} (\strong{required}): the number of samples; alternatively
an object of class \code{BayLum.list} can be provided as input (such as produced by \link{create_DataFile})}
}
\value{
Stratigraphic matrix where each sample are ordered by increasing order.
This matrix can be integrated in the function \link{AgeS_Computation}.
Please see \link{AgeS_Computation} for more information on this matrix.
}
\description{
Construct the stratigraphic matrix used in the functions \link{AgeS_Computation} and \link{AgeC14_Computation}
for samples that are all ordered by increasing age.
}
\examples{
SC <- SC_Ordered(Nb_sample = 3)

}
\seealso{
\link{AgeS_Computation}, \link{SCMatrix}
}
\author{
Claire Christophe, Anne Philippe, Sebastian Kreutzer, Guillaume Guérin
}
\keyword{datagen}
