% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{matern_corr}
\alias{matern_corr}
\title{Calculate a stationary Matern correlation matrix}
\usage{
matern_corr(dist, rho, nu)
}
\arguments{
\item{dist}{N x N matrix; contains values of pairwise Euclidean distances in
the x-y plane.}

\item{rho}{Scalar; "range" parameter used to rescale distances}

\item{nu}{Scalar; Matern smoothness parameter. \code{nu = 0.5} corresponds
to the Exponential correlation; \code{nu = Inf} corresponds to the Gaussian
correlation function.}
}
\value{
A correlation matrix for a fixed set of stations and fixed
parameter values.
}
\description{
\code{matern_corr} calculates a stationary Matern correlation matrix for a
fixed set of locations, based on a range and smoothness parameter. This
function is primarily used for the "npGP" and "approxGP" models. The
function is coded as a \code{nimbleFunction} (see the \code{nimble} package)
but can also be used as a regular R function.
}
\examples{
# Generate some coordinates
coords <- cbind(runif(100),runif(100))
nu <- 2
# Calculate distances -- can use nsDist to calculate Euclidean distances
dist_list <- nsDist(coords, isotropic = TRUE)
# Calculate the correlation matrix
corMat <- matern_corr(sqrt(dist_list$dist1_sq), 1, nu)

}
