% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MC_draw_UVT.R
\name{compute_MC_draws_uvt}
\alias{compute_MC_draws_uvt}
\title{Compute Monte Carlo Draws from Univariate Dataset}
\usage{
compute_MC_draws_uvt(
  Data,
  tau,
  num_treats,
  B,
  alph,
  gam,
  p_list,
  showBar = TRUE
)
}
\arguments{
\item{Data}{Observed data organised as a list of \eqn{\{y, X, A\}} where y is a vector of the final outcomes,
X is a list of matrices of the intermediate covariates and A is a matrix of the assigned treatments}

\item{tau}{Prior precision scale. Should be specified with a small value}

\item{num_treats}{Vector of number of treatment options at each stage}

\item{B}{Number of MC draws}

\item{alph}{Inverse-Gamma prior shape parameter for regression error variance of y. default:  1}

\item{gam}{Inverse-Gamma prior rate parameter for regression error variance of y. default:  1}

\item{p_list}{Vector of dimension for each stage}

\item{showBar}{Whether to show a progress bar. Uses bar from \link[progress]{progress_bar} deafult: TRUE}
}
\value{
Monte Carlo draws??? A list containing:  \enumerate{
\item thetat_B_list: Desc. A list of length num_stages with each element a vector of length B
\item sigmat_2B_list: Desc. A list of length num_stages with each element a vector of length B
\item beta_B: Desc. A list of length B
\item sigmay_2B: Desc. A list of length B
}
}
\description{
Obtain Monte Carlo draws from posterior distribution of stagewise regression parameters
}
\keyword{internal}
