## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(BiVariAn)

## ----warning=FALSE------------------------------------------------------------
auto_shapiro_raw(cars)

shapiro.test(cars$speed)

## -----------------------------------------------------------------------------
auto_shapiro_raw(cars, flextableformat = FALSE)

## -----------------------------------------------------------------------------
# Load riskCommunicator to access Framingham dataset
library(riskCommunicator)

## ----message=FALSE------------------------------------------------------------
# Load dplyr to select specific columns
library(dplyr)
data(cvdd)

## -----------------------------------------------------------------------------
set.seed(081224)
ex_sample<-slice_sample(cvdd, n=300)

## -----------------------------------------------------------------------------

auto_shapiro_raw(ex_sample %>% select(TOTCHOL, SYSBP, DIABP, BMI, HEARTRTE))

## -----------------------------------------------------------------------------
shapiro.test(ex_sample$TOTCHOL)

## -----------------------------------------------------------------------------
auto_shapiro_raw(ex_sample %>% select(TOTCHOL, SYSBP, DIABP, BMI, HEARTRTE), flextableformat = FALSE)

