% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.r
\name{compile_batch_stats}
\alias{compile_batch_stats}
\title{Compile Batch Statistics into a Tidy Data Frame}
\usage{
compile_batch_stats(img_list)
}
\arguments{
\item{img_list}{A list of 'BioThermR' objects (typically the output of a batch processing workflow).
Note: \code{\link{analyze_thermal_stats}} must be run on these objects first to populate the 'stats' slot.}
}
\value{
A \code{data.frame} where:
        \itemize{
          \item \strong{Rows} represent individual images.
          \item \strong{Columns} include 'Filename' and all metrics computed by \code{analyze_thermal_stats}
                (e.g., Min, Max, Mean, Median, SD, IQR, CV, Peak_Density).
        }
}
\description{
Iterates through a list of 'BioThermR' objects, extracts the pre-calculated statistics
             (from \code{analyze_thermal_stats}), and aggregates them into a single summary data frame.
             This function transforms the nested list structure into a flat, tabular format (Tidy Data)
             suitable for downstream statistical analysis (ANOVA, t-test) or visualization.
}
\examples{
\donttest{
# 1. Import and Process
img_obj_list <- system.file("extdata",package = "BioThermR")
img_list <- read_thermal_batch(img_obj_list)
img_list <- lapply(img_list, analyze_thermal_stats)

# 2. Compile Results
df_results <- compile_batch_stats(img_list)
}
}
